/*
 * Decompiled with CFR 0.152.
 */
package org.skills.events;

import java.util.EnumMap;
import org.bukkit.boss.BossBar;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.skills.events.SkillsEvent;
import org.skills.events.SkillsEventType;

public class SkillsEventManager
implements Listener {
    protected static final EnumMap<SkillsEventType, SkillsEvent> EVENTS = new EnumMap(SkillsEventType.class);

    public static EnumMap<SkillsEventType, SkillsEvent> getEvents() {
        return EVENTS;
    }

    public static SkillsEvent getEvent(SkillsEventType skillsEventType) {
        return EVENTS.get((Object)skillsEventType);
    }

    public static boolean isEventRunning(SkillsEventType skillsEventType) {
        SkillsEvent skillsEvent = SkillsEventManager.getEvent(skillsEventType);
        if (skillsEvent == null) {
            return false;
        }
        return skillsEvent.isActive();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        for (SkillsEvent skillsEvent : EVENTS.values()) {
            BossBar bossBar = skillsEvent.bossBar;
            if (bossBar == null) continue;
            bossBar.addPlayer(playerJoinEvent.getPlayer());
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        for (SkillsEvent skillsEvent : EVENTS.values()) {
            BossBar bossBar = skillsEvent.bossBar;
            if (bossBar == null) continue;
            bossBar.removePlayer(playerQuitEvent.getPlayer());
        }
    }
}

