/*
 * Decompiled with CFR 0.152.
 */
package org.skills.events;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.events.SkillsEventManager;
import org.skills.events.SkillsEventType;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.LanguageManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.NoEpochDate;
import org.skills.utils.StringUtils;

public class SkillsEvent {
    public final long time;
    public final long start;
    private final transient SkillsEventType type;
    private final String multiplier;
    private final transient UUID id;
    public transient boolean stopped;
    protected transient BossBar bossBar;
    private transient boolean global;

    public SkillsEvent(UUID uUID, SkillsEventType skillsEventType, String string, long l, TimeUnit timeUnit, long l2) {
        Objects.requireNonNull(skillsEventType, "Event type cannot be null");
        Objects.requireNonNull(string, "Event multiplier cannot be null");
        this.id = uUID;
        this.type = skillsEventType;
        this.multiplier = string;
        this.time = timeUnit.toMillis(l);
        this.start = l2;
    }

    public SkillsEvent(UUID uUID, SkillsEventType skillsEventType, String string, long l, TimeUnit timeUnit) {
        this(uUID, skillsEventType, string, l, timeUnit, System.currentTimeMillis());
    }

    public SkillsEvent(UUID uUID, SkillsEventType skillsEventType, String string, long l) {
        this(uUID, skillsEventType, string, l, TimeUnit.MILLISECONDS, System.currentTimeMillis());
    }

    public void stop() {
        this.stopped = true;
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
        SkillsEventManager.EVENTS.remove((Object)this.type);
    }

    public SkillsEvent clone() {
        return new SkillsEvent(this.id, this.type, this.multiplier, this.time, TimeUnit.MILLISECONDS, System.currentTimeMillis());
    }

    public void start() {
        boolean bl;
        if (SkillsEventManager.isEventRunning(this.type)) {
            throw new IllegalArgumentException((Object)((Object)this.type) + " event is already running");
        }
        SkillsEventManager.getEvents().put(this.type, this);
        boolean bl2 = bl = this.global ? SkillsConfig.BOSSBAR_EVENTS_ENABLED.getBoolean() : SkillsConfig.BOSSBAR_BONUSES_ENABLED.getBoolean();
        if (bl) {
            final SkillsConfig skillsConfig = this.global ? SkillsConfig.BOSSBAR_EVENTS : SkillsConfig.BOSSBAR_BONUSES;
            this.bossBar = StringUtils.parseBossBarFromConfig(null, skillsConfig.getSection());
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.bossBar.addPlayer(player);
            }
            new BukkitRunnable(){

                public void run() {
                    if (!SkillsEvent.this.isActive()) {
                        this.cancel();
                        if (!SkillsEvent.this.stopped) {
                            SkillsEvent.this.stop();
                        }
                        return;
                    }
                    float f = Math.abs((float)SkillsEvent.this.getTimeLeft() / (float)SkillsEvent.this.time);
                    SkillsEvent.this.bossBar.setProgress((double)f);
                    SkillsEvent.this.bossBar.setTitle(LanguageManager.buildMessage(skillsConfig.getSection().getString("title"), null, "%type%", SkillsEvent.this.type.toString(), "%multiplier%", String.valueOf(SkillsEvent.this.calcMultiplier(null)), "%time%", new NoEpochDate(SkillsEvent.this.getTimeLeft()).format(SkillsConfig.TIME_FORMAT.getString())));
                }
            }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
        }
        this.global = true;
    }

    public String toString() {
        return this.type.name() + ", " + this.multiplier + ", " + this.time + ", " + this.start;
    }

    public SkillsEventType getType() {
        return this.type;
    }

    public String getMultiplier() {
        return this.multiplier;
    }

    public double calcMultiplier(OfflinePlayer offlinePlayer) {
        String string = this.multiplier;
        if (offlinePlayer != null) {
            string = ServiceHandler.translatePlaceholders(offlinePlayer, this.getMultiplier());
        }
        return MathUtils.evaluateEquation(string);
    }

    public String getDisplayTime() {
        return new NoEpochDate(this.getTimeLeft()).format(SkillsConfig.TIME_FORMAT.getString());
    }

    public long getStart() {
        return this.start;
    }

    public long getTimeLeft() {
        return Math.max(0L, this.time - this.getPassedTime());
    }

    public long getPassedTime() {
        return System.currentTimeMillis() - this.start;
    }

    public boolean isActive() {
        return !this.stopped && this.getTimeLeft() != 0L;
    }

    public UUID getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isGlobal() {
        return this.global;
    }
}

