/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.api.events.EidolonImbalanceChangeEvent;
import org.skills.api.events.SkillActiveStateChangeEvent;
import org.skills.api.events.SkillEnergyChangeEvent;
import org.skills.api.events.SkillImproveEvent;
import org.skills.api.events.SkillLevelUpEvent;
import org.skills.api.events.SkillToggleAbilityEvent;
import org.skills.data.database.DataContainer;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.PlayerSkill;
import org.skills.events.SkillsEvent;
import org.skills.events.SkillsEventType;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.LevelManager;
import org.skills.managers.LevelUp;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;
import org.skills.party.PartyRank;
import org.skills.party.SkillsParty;
import org.skills.types.Skill;
import org.skills.types.SkillScaling;
import org.skills.types.Stat;
import org.skills.utils.Cooldown;
import org.skills.utils.FastUUID;
import org.skills.utils.NoEpochDate;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.xseries.XSound;

public class SkilledPlayer
extends DataContainer {
    private transient PlayerSkill skill = new PlayerSkill("none");
    private Map<String, PlayerSkill> skills = new HashMap<String, PlayerSkill>(){
        {
            this.put("none", SkilledPlayer.this.skill);
        }
    };
    private transient UUID id;
    private transient ActiveAbility lastAbilityUsed;
    private transient double energyBooster;
    private double healthScaling = SkillsConfig.DEFAULT_HEALTH_SCALING.getDouble();
    private transient double energy;
    private long lastSkillChange;
    private transient EidolonForm form = EidolonForm.LIGHT;
    private transient String activeReady;
    private Map<String, Integer> masteries = new HashMap<String, Integer>();
    private Map<SkillsEventType, SkillsEvent> bonuses = new EnumMap<SkillsEventType, SkillsEvent>(SkillsEventType.class);
    private Map<String, Cosmetic> cosmetics = new HashMap<String, Cosmetic>();
    private Set<UUID> friends = new HashSet<UUID>();
    private Set<UUID> friendRequests = new HashSet<UUID>();
    private UUID party;
    private PartyRank rank;

    public SkilledPlayer(UUID uUID) {
        this(uUID, false);
    }

    public SkilledPlayer(UUID uUID, boolean bl) {
        Objects.requireNonNull(uUID, "Skilled Player's UUID cannot be null");
        this.id = uUID;
        if (!bl) {
            SkillsPro.get().getPlayerDataManager().load(this);
        }
    }

    public SkilledPlayer(boolean bl) {
    }

    public static @NonNull SkilledPlayer getSkilledPlayer(@NonNull UUID uUID) {
        Objects.requireNonNull(uUID, "Cannot get skilled player data with null player UUID");
        SkilledPlayer skilledPlayer = (SkilledPlayer)SkillsPro.get().getPlayerDataManager().getData(uUID);
        if (skilledPlayer == null) {
            skilledPlayer = new SkilledPlayer(uUID);
            if (SkillsConfig.STARTER_ENABLED.getBoolean()) {
                skilledPlayer.setLevel(SkillsConfig.STARTER_LEVEL.getInt());
                skilledPlayer.setSouls(SkillsConfig.STARTER_SOULS.getLong());
                ConfigurationSection configurationSection = SkillsConfig.STARTER_STATS.getSection();
                for (Object object : configurationSection.getKeys(false)) {
                    Stat object2 = Stat.getStat((String)object);
                    if (object2 == null) continue;
                    skilledPlayer.setStat(object2, configurationSection.getInt((String)object));
                }
                int n = SkillsConfig.STARTER_MASTERIES.getInt();
                if (n > 0) {
                    for (Mastery mastery : MasteryManager.getMasteries()) {
                        skilledPlayer.getMasteries().put(mastery.getName(), n);
                    }
                }
            }
        }
        return skilledPlayer;
    }

    public static @NonNull SkilledPlayer getSkilledPlayer(@NonNull OfflinePlayer offlinePlayer) {
        Objects.requireNonNull(offlinePlayer, "Cannot get skilled player data for null player");
        return SkilledPlayer.getSkilledPlayer(offlinePlayer.getUniqueId());
    }

    public Set<UUID> getFriends() {
        return this.friends;
    }

    public void setFriends(Set<UUID> set) {
        this.friends = set;
    }

    public Set<UUID> getFriendRequests() {
        return this.friendRequests;
    }

    public void setFriendRequests(Set<UUID> set) {
        this.friendRequests = set;
    }

    public Map<SkillsEventType, SkillsEvent> getBonuses() {
        for (Map.Entry<SkillsEventType, SkillsEvent> entry : this.bonuses.entrySet()) {
            if (entry.getValue().isActive()) continue;
            this.bonuses.remove((Object)entry.getKey());
        }
        return this.bonuses;
    }

    public void setBonuses(Map<SkillsEventType, SkillsEvent> map) {
        this.bonuses = map;
    }

    public Map<String, PlayerSkill> getSkills() {
        return this.skills;
    }

    public void setSkills(Map<String, PlayerSkill> map) {
        this.skills = map;
    }

    public double getLevelXP(int n) {
        return LevelUp.getLevel(this, n);
    }

    public double getLevelXP() {
        return this.getLevelXP(this.skill.getLevel());
    }

    public BukkitTask setEnergy(final double d) {
        final Player player = this.getPlayer();
        Validate.isTrue((player != null ? 1 : 0) != 0, (String)"Cannot set energy of offline player");
        return new BukkitRunnable(){

            public void run() {
                SkillEnergyChangeEvent skillEnergyChangeEvent = new SkillEnergyChangeEvent(player, SkilledPlayer.this, d);
                Bukkit.getPluginManager().callEvent((Event)skillEnergyChangeEvent);
                if (skillEnergyChangeEvent.isCancelled()) {
                    return;
                }
                SkilledPlayer.this.energy = skillEnergyChangeEvent.getAmount();
                if (SkilledPlayer.this.skill.getSkillName().equalsIgnoreCase("eidolon") && SkilledPlayer.this.energy >= SkilledPlayer.this.getScaling(SkillScaling.MAX_ENERGY)) {
                    EidolonForm eidolonForm = SkilledPlayer.this.form == EidolonForm.DARK ? EidolonForm.LIGHT : EidolonForm.DARK;
                    EidolonImbalanceChangeEvent eidolonImbalanceChangeEvent = new EidolonImbalanceChangeEvent(player, eidolonForm);
                    Bukkit.getPluginManager().callEvent((Event)eidolonImbalanceChangeEvent);
                    SkilledPlayer.this.form = eidolonImbalanceChangeEvent.getNewForm();
                    SkilledPlayer.this.energy = 0.0;
                }
            }
        }.runTaskAsynchronously((Plugin)SkillsPro.get());
    }

    public void setCooldown(long l) {
        new Cooldown(this.id, "CD", l);
    }

    public long getCooldownTimeLeft() {
        return Cooldown.getTimeLeft(this.id, "CD");
    }

    public boolean isInCooldown() {
        return Cooldown.isInCooldown(this.id, "CD");
    }

    public boolean showReadyMessage() {
        return this.skill.showReadyMessage();
    }

    public void setShowReadyMessage(boolean bl) {
        this.skill.setShowReadyMessage(bl);
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    public void setId(@NonNull UUID uUID) {
        Objects.requireNonNull(uUID, "Cannot set Skilled player's UUID to null");
        this.id = uUID;
    }

    @Override
    @NotNull
    public String getCompressedData() {
        return this.skill + SkilledPlayer.compressUUID(this.party) + (this.rank == null ? "" : Integer.valueOf(this.rank.ordinal())) + this.healthScaling + SkilledPlayer.compressCollecton(this.bonuses.values(), skillsEvent -> skillsEvent.start + skillsEvent.time) + SkilledPlayer.compressCollecton(this.masteries.values(), n -> n) + SkilledPlayer.compressCollecton(this.friends, uUID -> DataContainer.compressUUID(uUID)) + SkilledPlayer.compressCollecton(this.friendRequests, uUID -> DataContainer.compressUUID(uUID)) + SkilledPlayer.compressCollecton(this.skills.values(), PlayerSkill::getCompressedData);
    }

    @Override
    public @NonNull String getKey() {
        return FastUUID.toString(this.id);
    }

    @Override
    public void setIdentifier(@NonNull String string) {
        this.id = FastUUID.fromString(string);
    }

    public @Nullable Skill getSkill() {
        return this.skill.getSkill();
    }

    public void setAbsoluteActiveSkill(@NonNull PlayerSkill playerSkill) {
        Objects.requireNonNull(playerSkill, "Active player skill cannot be null");
        this.skill = playerSkill;
    }

    public void setActiveSkill(@NonNull String string) {
        PlayerSkill playerSkill = this.skills.get(string);
        if (playerSkill == null) {
            playerSkill = new PlayerSkill(string);
            this.skills.put(string, playerSkill);
        }
        if (SkillsConfig.SKILLS_SHARED_DATA_SOULS.getBoolean()) {
            playerSkill.setSouls(this.getSouls());
        }
        if (SkillsConfig.SKILLS_SHARED_DATA_STATS.getBoolean()) {
            playerSkill.setStats(this.getStats());
        }
        if (SkillsConfig.SKILLS_SHARED_DATA_LEVELS.getBoolean()) {
            playerSkill.setLevel(this.getLevel());
            playerSkill.setAbsoluteXP(this.getXP());
        }
        this.skills.put(this.skill.skill, this.skill);
        this.skill = playerSkill;
    }

    public void setActiveSkill(@NonNull Skill skill) {
        this.setActiveSkill(skill.getName());
        this.changedSkill();
    }

    public int getLevel() {
        return this.skill.getLevel();
    }

    public void setLevel(int n) {
        this.skill.setLevel(n);
    }

    public double getXP() {
        return this.skill.getXP();
    }

    public void setXP(double d) {
        this.setXP(d, false);
    }

    public void setXP(double d, boolean bl) {
        double d2;
        if (d == 0.0) {
            return;
        }
        Validate.isTrue((d >= 0.0 ? 1 : 0) != 0, (String)"Cannot set negative XP");
        while (d >= (d2 = this.getLevelXP(this.skill.getLevel()))) {
            d -= d2;
            if (bl) {
                ++this.skill.level;
                continue;
            }
            this.levelUp(1);
        }
        this.skill.xp = d;
    }

    public void setAbsoluteXP(double d) {
        this.skill.xp = d;
    }

    public void chargeEnergy() {
        this.chargeEnergy(0.0);
    }

    public void chargeEnergy(double d) {
        Skill skill = this.getSkill();
        if (!Cooldown.isInCooldown(this.id, "ENERGY_BOOSTER")) {
            this.setEnergyBooster(0.0);
        }
        double d2 = this.getEnergyBooster();
        double d3 = skill.getScaling(this, SkillScaling.MAX_ENERGY);
        double d4 = skill.getScaling(this, SkillScaling.ENERGY_REGEN) + d + d2;
        double d5 = this.energy;
        if (d5 >= d3) {
            return;
        }
        d5 = this.energy + d4 >= d3 ? d3 : (d5 += d4);
        this.setEnergy(d5);
        if (d5 >= d3) {
            XSound.play(this.getPlayer(), this.getSkill().getEnergy().getSoundFull());
        }
    }

    public void addXP(double d) {
        this.addXP(d, false);
    }

    public void addSouls(long l) {
        this.skill.souls += l;
    }

    public void addXP(double d, boolean bl) {
        if (d == 0.0) {
            return;
        }
        if (d < 0.0) {
            this.decreaseXP(-d);
        } else {
            this.setXP(this.skill.xp + d, bl);
        }
    }

    public String getSkillName() {
        return this.skill.skill;
    }

    private void decreaseXP(double d) {
        block3: {
            if (d == 0.0) {
                return;
            }
            while (this.skill.xp - d < 0.0) {
                d -= this.skill.xp;
                --this.skill.level;
                if (this.skill.level < 0) {
                    this.skill.level = 0;
                    break block3;
                }
                this.skill.xp = this.getLevelXP(this.skill.level);
            }
            this.skill.xp -= d;
        }
    }

    public void setRawXP(double d, boolean bl) {
        this.setLevel(0);
        int n = 0;
        while (true) {
            double d2;
            if (!(d >= (d2 = this.getLevelXP(n)))) break;
            d -= d2;
            if (bl) {
                ++this.skill.level;
            } else {
                this.levelUp(1);
            }
            ++n;
        }
        this.skill.xp = d;
    }

    public double getRawXP() {
        if (this.skill.level < 1) {
            return this.skill.xp;
        }
        return this.skill.xp + this.getLevelXP(this.skill.level - 1);
    }

    public boolean willLevelUp(double d) {
        return this.skill.xp + d >= this.getLevelXP(this.skill.level);
    }

    public long getSouls() {
        return this.skill.souls;
    }

    public void setSouls(long l) {
        this.skill.souls = l;
    }

    public boolean hasSkill() {
        return !this.skill.skill.equals("none");
    }

    public int getMasteryLevel(Mastery mastery) {
        return this.masteries.getOrDefault(mastery.getName().toLowerCase(), 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SkilledPlayer)) {
            return false;
        }
        SkilledPlayer skilledPlayer = (SkilledPlayer)object;
        return this.id.equals(skilledPlayer.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void setScaledHealth() {
        Player player = this.getPlayer();
        Validate.isTrue((player != null ? 1 : 0) != 0, (String)"Cannot scale an offline players health");
        if (this.healthScaling < 0.0) {
            MessageHandler.sendConsolePluginMessage("&cInvalid health scaling for " + player.getName() + ": " + this.healthScaling + ". Resetting...");
            this.healthScaling = 0.0;
            return;
        }
        if (this.healthScaling == 0.0) {
            player.setHealthScaled(false);
            return;
        }
        if (!player.isHealthScaled()) {
            player.setHealthScaled(true);
        }
        player.setHealthScale(this.healthScaling);
    }

    public boolean hasAbility(Ability ability) {
        return this.getSkill().hasAbility(ability);
    }

    public @NonNull List<String> getDisabledAbilities() {
        return this.skill.disabledAbilities;
    }

    public void setDisabledAbilities(List<String> list) {
        this.skill.disabledAbilities = list;
    }

    public boolean isActiveReady(ActiveAbility activeAbility) {
        return activeAbility.getName().equals(this.activeReady);
    }

    public boolean setActiveReady(ActiveAbility activeAbility, boolean bl) {
        if (bl ? this.isActiveReady(activeAbility) : !this.isActiveReady()) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            throw new IllegalArgumentException("Cannot change an offline player ability state");
        }
        SkillActiveStateChangeEvent skillActiveStateChangeEvent = new SkillActiveStateChangeEvent(player, activeAbility, bl);
        Bukkit.getPluginManager().callEvent((Event)skillActiveStateChangeEvent);
        if (skillActiveStateChangeEvent.isCancelled()) {
            return false;
        }
        this.activeReady = bl ? activeAbility.getName() : null;
        return true;
    }

    public void deactivateReady() {
        this.activeReady = null;
    }

    public String getActiveReady() {
        return this.activeReady;
    }

    public boolean isActiveReady() {
        return this.activeReady != null;
    }

    public double getScaling(SkillScaling skillScaling) {
        return this.getSkill().getScaling(this, skillScaling);
    }

    public void levelUp(int n) {
        if (n == 0) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            int n2 = (int)this.getScaling(SkillScaling.MAX_LEVEL);
            int n3 = this.skill.level + n;
            if (this.skill.level >= n2) {
                SkillsLang.MAX_LEVEL.sendMessage(player, new Object[0]);
                return;
            }
            if (n3 > n2) {
                n = n3 - n2;
            }
            SkillLevelUpEvent skillLevelUpEvent = new SkillLevelUpEvent(this, player, n);
            Bukkit.getPluginManager().callEvent((Event)skillLevelUpEvent);
            if (skillLevelUpEvent.isCancelled()) {
                return;
            }
            LevelManager.onLevelUp(skillLevelUpEvent);
            this.skill.level += skillLevelUpEvent.getAddedLevel();
        } else {
            ++this.skill.level;
        }
        this.skill.xp = 0.0;
    }

    public boolean canChangeSkill() {
        if (this.lastSkillChange < 1L) {
            return true;
        }
        long l = SkillsConfig.SKILL_CHANGE_COOLDOWN.getTimeMillis();
        if (l < 0L) {
            return false;
        }
        if (l == 0L) {
            return true;
        }
        return System.currentTimeMillis() - this.lastSkillChange > l;
    }

    public long getTimeLeftToChangeSkill() {
        long l = SkillsConfig.SKILL_CHANGE_COOLDOWN.getTimeMillis();
        if (l < 1L) {
            return 0L;
        }
        long l2 = System.currentTimeMillis() - this.lastSkillChange;
        if (l2 < 1L) {
            return 0L;
        }
        return Math.abs(l - l2);
    }

    public String getTimeLeftToChangeSkillString() {
        return new NoEpochDate(this.getTimeLeftToChangeSkill()).format(SkillsConfig.TIME_FORMAT.getString());
    }

    public void changedSkill() {
        this.lastSkillChange = System.currentTimeMillis();
    }

    public @NonNull OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.id);
    }

    public @Nullable Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.id);
    }

    public EidolonForm getForm() {
        return this.form;
    }

    public void setForm(@NonNull EidolonForm eidolonForm) {
        this.form = eidolonForm;
    }

    public void toggleAbility(Ability ability) {
        boolean bl = false;
        if (!this.skill.disabledAbilities.remove(ability.getName())) {
            this.skill.disabledAbilities.add(ability.getName());
            bl = true;
        }
        SkillToggleAbilityEvent skillToggleAbilityEvent = new SkillToggleAbilityEvent(this.getPlayer(), ability, bl);
        Bukkit.getPluginManager().callEvent((Event)skillToggleAbilityEvent);
    }

    public boolean isAbilityDisabled(Ability ability) {
        return this.skill.disabledAbilities.contains(ability.getName());
    }

    public @NonNull SkillsEvent getBonus(SkillsEventType skillsEventType) {
        return this.getBonuses().get((Object)skillsEventType);
    }

    public void addBonus(SkillsEvent skillsEvent) {
        Validate.isTrue((!skillsEvent.isGlobal() ? 1 : 0) != 0, (String)"Cannot add global skill events as a bonus");
        this.bonuses.put(skillsEvent.getType(), skillsEvent);
    }

    public boolean hasParty() {
        return this.party != null;
    }

    public SkillsEvent removeBonus(SkillsEventType skillsEventType) {
        return this.bonuses.remove((Object)skillsEventType);
    }

    public void purgeUnusedBonuses() {
        for (SkillsEvent skillsEvent : this.bonuses.values()) {
            if (skillsEvent.isActive()) continue;
            this.bonuses.remove((Object)skillsEvent.getType());
        }
    }

    public void upgradeAbility(@NonNull Ability ability) {
        this.addImprovementLevel(ability, 1);
        SkillImproveEvent skillImproveEvent = new SkillImproveEvent(this.getPlayer(), ability);
        Bukkit.getPluginManager().callEvent((Event)skillImproveEvent);
    }

    public void setAbilityLevel(@NonNull Ability ability, int n) {
        this.skill.setImprovement(ability, n);
    }

    public int getStat(@NonNull String string) {
        return this.skill.getStats().getOrDefault(string.toUpperCase(Locale.ENGLISH), 0);
    }

    public int getStat(@Nonnull Stat stat) {
        return this.getStat(stat.getDataNode());
    }

    public int getPoints() {
        return this.getStat(Stat.POINTS.getDataNode());
    }

    public void addStat(@NonNull String string, int n) {
        this.setStat(string, this.getStat(string) + n);
    }

    public void addStat(Stat stat, int n) {
        this.addStat(stat.getDataNode(), n);
    }

    public void setStat(@NonNull String string, int n) {
        this.skill.getStats().put(string, n);
    }

    public void setStat(@Nonnull Stat stat, int n) {
        this.skill.getStats().put(stat.getDataNode(), n);
    }

    public int resetStats() {
        return this.skill.resetStats();
    }

    public Map<String, Integer> getStats() {
        return this.skill.getStats();
    }

    public void setMasteryLevel(@NonNull Mastery mastery, int n) {
        this.masteries.put(mastery.getName().toLowerCase(), n);
    }

    public void addMasteryLevel(@NonNull Mastery mastery, int n) {
        if (n != 0) {
            this.setMasteryLevel(mastery, this.getMasteryLevel(mastery) + n);
        }
    }

    public @NonNull Map<String, Integer> getMasteries() {
        return this.masteries;
    }

    public void setMasteries(@NonNull HashMap<String, Integer> hashMap) {
        this.masteries = hashMap;
    }

    public @NonNull Map<String, HashMap<String, Integer>> getImprovements() {
        return this.skill.abilities;
    }

    public void setImprovements(@NonNull HashMap<String, HashMap<String, Integer>> hashMap) {
        this.skill.abilities = hashMap;
    }

    public void setImprovement(@NonNull Ability ability, int n) {
        this.skill.setImprovement(ability, n);
    }

    public void addImprovementLevel(@NonNull Ability ability, int n) {
        this.skill.addImprovementLevel(ability, n);
    }

    public int getImprovementLevel(@NonNull Ability ability) {
        return this.skill.getImprovementLevel(ability);
    }

    public long getLastSkillChange() {
        return this.lastSkillChange;
    }

    public void setLastSkillChange(long l) {
        this.lastSkillChange = l;
    }

    public List<OfflinePlayer> getPlayerFriends() {
        ArrayList<OfflinePlayer> arrayList = new ArrayList<OfflinePlayer>();
        for (UUID uUID : this.friends) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            arrayList.add(offlinePlayer);
        }
        return arrayList;
    }

    public UUID getPartyId() {
        return this.party;
    }

    public SkillsParty getParty() {
        boolean bl = this.hasParty();
        if (!bl) {
            return null;
        }
        SkillsParty skillsParty = SkillsParty.getParty(this.party);
        if (skillsParty == null && bl) {
            MessageHandler.sendConsolePluginMessage("&4Invalid party data for &e" + this.getOfflinePlayer().getName() + "&4. Removing them from party now... Please do not report if any error occured after this message.");
            this.party = null;
            this.rank = null;
        }
        return skillsParty;
    }

    public void setParty(SkillsParty skillsParty) {
        this.party = skillsParty.getId();
    }

    public void setParty(UUID uUID) {
        this.party = uUID;
    }

    public void joinParty(SkillsParty skillsParty) {
        this.setParty(skillsParty);
        skillsParty.getMembers().add(this.id);
        this.rank = PartyRank.MEMBER;
    }

    public void leaveParty() {
        this.getParty().getMembers().remove(this.id);
        this.party = null;
        this.rank = null;
    }

    public void friendRequest(Player player) {
        this.friendRequests.add(player.getUniqueId());
    }

    public void settleFriendRequest(Player player) {
        this.friendRequests.remove(player.getUniqueId());
    }

    public PartyRank getRank() {
        return this.rank;
    }

    public void setRank(PartyRank partyRank) {
        this.rank = partyRank;
    }

    public boolean isFrendly(SkilledPlayer skilledPlayer) {
        if (this.friends.contains(skilledPlayer.getId())) {
            return true;
        }
        return this.party != null && this.party.equals(skilledPlayer.getPartyId());
    }

    public boolean isFrendly(OfflinePlayer offlinePlayer) {
        return this.isFrendly(SkilledPlayer.getSkilledPlayer(offlinePlayer));
    }

    public double getHealthScaling() {
        return this.healthScaling;
    }

    public void setHealthScaling(double d) {
        this.healthScaling = d;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getEnergyBooster() {
        return this.energyBooster;
    }

    public void setEnergyBooster(double d) {
        this.energyBooster = d;
    }

    public ActiveAbility getLastAbilityUsed() {
        return this.lastAbilityUsed;
    }

    public void setLastAbilityUsed(ActiveAbility activeAbility) {
        this.lastAbilityUsed = activeAbility;
    }

    public Map<String, Cosmetic> getCosmetics() {
        return this.cosmetics;
    }

    public void setCosmetics(Map<String, Cosmetic> map) {
        this.cosmetics = map;
    }

    public Cosmetic getCosmetic(String string) {
        Cosmetic cosmetic = this.cosmetics.get(string);
        if (cosmetic != null) {
            return cosmetic;
        }
        CosmeticCategory cosmeticCategory = CosmeticCategory.CATEGORIES.get(string);
        if (cosmeticCategory != null) {
            return cosmeticCategory.getCosmetics().get("none");
        }
        return null;
    }
}

