/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.skills.abilities.Ability;
import org.skills.data.database.DataContainer;
import org.skills.types.Skill;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class PlayerSkill
extends DataContainer {
    protected final String skill;
    protected int level;
    protected double xp;
    protected long souls;
    protected boolean showReadyMessage = true;
    protected List<String> disabledAbilities = new ArrayList<String>();
    protected Map<String, HashMap<String, Integer>> abilities = new HashMap<String, HashMap<String, Integer>>();
    private Map<String, Integer> stats = new HashMap<String, Integer>();

    public PlayerSkill(String string) {
        this.skill = string;
    }

    @Override
    public @NonNull String getCompressedData() {
        return (double)this.level + this.xp + (double)this.souls + PlayerSkill.compressBoolean(this.showReadyMessage) + PlayerSkill.compressCollecton(this.disabledAbilities, string -> string) + PlayerSkill.compressCollecton(this.abilities.values(), hashMap -> hashMap) + PlayerSkill.compressCollecton(this.stats.values(), n -> n);
    }

    public boolean showReadyMessage() {
        return this.showReadyMessage;
    }

    public void setShowReadyMessage(boolean bl) {
        this.showReadyMessage = bl;
    }

    public @Nullable Skill getSkill() {
        return SkillManager.getSkill(this.skill);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public double getXP() {
        return this.xp;
    }

    public void setAbsoluteXP(double d) {
        this.xp = d;
    }

    public void addSouls(int n) {
        this.souls += (long)n;
    }

    public String getSkillName() {
        return this.skill;
    }

    public long getSouls() {
        return this.souls;
    }

    public void setSouls(long l) {
        this.souls = l;
    }

    public boolean hasAbility(Ability ability) {
        return this.getSkill().hasAbility(ability);
    }

    public @NonNull List<String> getDisabledAbilities() {
        return this.disabledAbilities;
    }

    public void setDisabledAbilities(List<String> list) {
        this.disabledAbilities = list;
    }

    public boolean isAbilityDisabled(Ability ability) {
        return this.disabledAbilities.contains(ability.getName());
    }

    public int hashCode() {
        return this.skill.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlayerSkill)) {
            return false;
        }
        PlayerSkill playerSkill = (PlayerSkill)object;
        return this.skill.equals(playerSkill.skill);
    }

    public String toString() {
        return this.skill + this.abilities + this.souls + this.xp + this.level + this.stats + this.showReadyMessage + this.disabledAbilities;
    }

    public int getStat(@NonNull String string) {
        return this.stats.getOrDefault(string.toUpperCase(Locale.ENGLISH), 0);
    }

    public int getStat(@Nonnull Stat stat) {
        return this.getStat(stat.getDataNode());
    }

    public int getPoints() {
        return this.getStat(Stat.POINTS.getDataNode());
    }

    public void addStat(@NonNull String string, int n) {
        this.setStat(string, this.getStat(string) + n);
    }

    public void addStat(Stat stat, int n) {
        this.addStat(stat.getDataNode(), n);
    }

    public void setStat(@NonNull String string, int n) {
        this.stats.put(string, n);
    }

    public void setStat(@Nonnull Stat stat, int n) {
        this.stats.put(stat.getDataNode(), n);
    }

    public int resetStats() {
        int n = 0;
        for (Map.Entry<String, Integer> entry : this.stats.entrySet()) {
            n += entry.getValue().intValue();
            this.setStat(entry.getKey(), 0);
        }
        this.setStat(Stat.POINTS, n);
        return n;
    }

    public Map<String, Integer> getStats() {
        return this.stats;
    }

    public void setStats(Map<String, Integer> map) {
        Objects.requireNonNull(map, "Player stats cannot be null");
        this.stats = map;
    }

    public @NonNull Map<String, HashMap<String, Integer>> getImprovements() {
        return this.abilities;
    }

    public void setImprovements(@NonNull HashMap<String, HashMap<String, Integer>> hashMap) {
        this.abilities = hashMap;
    }

    public void setImprovement(@NonNull Ability ability, int n) {
        String string = this.skill.toLowerCase(Locale.ENGLISH);
        HashMap<String, Integer> hashMap = this.abilities.get(string);
        if (hashMap == null) {
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            hashMap2.put(ability.getName().toLowerCase(), n);
            this.abilities.put(string, hashMap2);
            return;
        }
        hashMap.put(ability.getName().toLowerCase(), n);
        this.abilities.put(string, hashMap);
    }

    public void addImprovementLevel(@NonNull Ability ability, int n) {
        if (n == 0) {
            return;
        }
        String string = this.skill.toLowerCase(Locale.ENGLISH);
        String string2 = ability.getName().toLowerCase();
        HashMap<String, Integer> hashMap = this.abilities.get(string);
        if (hashMap == null) {
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            hashMap2.put(string2, n);
            this.abilities.put(string, hashMap2);
            return;
        }
        Integer n2 = hashMap.putIfAbsent(string2, n);
        if (n2 == null) {
            return;
        }
        hashMap.put(string2, n2 + n);
        this.abilities.put(string, hashMap);
    }

    public int getImprovementLevel(@NonNull Ability ability) {
        String string = this.skill.toLowerCase(Locale.ENGLISH);
        HashMap<String, Integer> hashMap = this.abilities.get(string);
        return hashMap != null ? hashMap.getOrDefault(ability.getName().toLowerCase(), 0) : 0;
    }

    @Override
    public @NonNull String getKey() {
        return this.skill;
    }

    @Override
    public void setIdentifier(@NonNull String string) {
    }
}

