/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.data.managers.DataHandlers;
import org.skills.data.managers.DataManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;
import org.skills.utils.FastUUID;
import org.skills.utils.MathUtils;

public class PlayerDataManager
extends DataManager<SkilledPlayer> {
    private static final Map<UUID, Integer> LEVELS = new ConcurrentHashMap<UUID, Integer>();

    public PlayerDataManager(SkillsPro skillsPro) {
        super(DataHandlers.getDatabase(skillsPro, "players", SkilledPlayer.class));
        this.autoSave(skillsPro);
    }

    public static void addLevel(OfflinePlayer offlinePlayer, int n) {
        LEVELS.put(offlinePlayer.getUniqueId(), n);
    }

    public static CompletableFuture<List<UUID>> getTopLevels(int n) {
        int n2 = LEVELS.size();
        if (n2 <= n) {
            n = n2;
        }
        int n3 = n;
        return CompletableFuture.supplyAsync(() -> LEVELS.entrySet().stream().sorted(Map.Entry.comparingByValue()).skip(n2 - n3).map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    @Override
    public void saveAll() {
        int n = 0;
        for (SkilledPlayer skilledPlayer : this.cache.asMap().values()) {
            if (!skilledPlayer.shouldSave()) continue;
            this.save(skilledPlayer);
            ++n;
        }
        if (SkillsConfig.ANNOUNCE_AUTOSAVES.getBoolean()) {
            MessageHandler.sendConsolePluginMessage("Saved a total of &e" + n + " &3players data.");
        }
    }

    private void generateCrap() {
        for (int i = 0; i < 1000; ++i) {
            SkilledPlayer skilledPlayer = new SkilledPlayer(UUID.randomUUID());
            skilledPlayer.setXP(MathUtils.randInt(0, 10));
            skilledPlayer.setLevel(MathUtils.randInt(0, 100));
            skilledPlayer.setSouls(MathUtils.randInt(0, 1000));
            for (int j = 0; j < MathUtils.randInt(1, MasteryManager.getMasteries().size()); ++j) {
                Mastery mastery = MasteryManager.getMasteries().get(MathUtils.randInt(0, MasteryManager.getMasteries().size() - 1));
                skilledPlayer.setMasteryLevel(mastery, MathUtils.randInt(0, 45));
            }
        }
    }

    public void setTopLevels(SkillsPro skillsPro) {
        new BukkitRunnable(){

            public void run() {
                boolean bl = SkillsConfig.LOAD_ALL_DATA_ON_STARTUP.getBoolean();
                int n = 0;
                for (String string : PlayerDataManager.this.database.getAllKeys()) {
                    SkilledPlayer skilledPlayer;
                    String string2 = string.substring(0, string.length() - 5);
                    UUID uUID = FastUUID.fromString(string2);
                    SkilledPlayer skilledPlayer2 = skilledPlayer = bl ? (SkilledPlayer)PlayerDataManager.this.getData(uUID) : (SkilledPlayer)PlayerDataManager.this.peek(uUID);
                    if (skilledPlayer != null) {
                        LEVELS.put(uUID, skilledPlayer.getLevel());
                    } else {
                        MessageHandler.sendConsolePluginMessage("&cCould not load data for &e" + uUID);
                    }
                    ++n;
                }
                MessageHandler.sendConsolePluginMessage("&3Loaded &e" + n + " &3player data.");
            }
        }.runTaskAsynchronously((Plugin)skillsPro);
    }
}

