/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.io.File;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.skills.data.database.DataContainer;
import org.skills.data.database.SkillsDatabase;
import org.skills.data.database.json.JsonDatabase;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.StringUtils;

public class DataHandlers
implements Listener {
    private final SkillsPro plugin;

    public DataHandlers(SkillsPro skillsPro) {
        this.plugin = skillsPro;
    }

    public static <T extends DataContainer> SkillsDatabase<T> getDatabase(SkillsPro skillsPro, String string, Class<T> clazz) {
        String string2 = SkillsConfig.DATABASE.getString().toLowerCase();
        if (string2.equals("json")) {
            return new JsonDatabase<T>(new File(skillsPro.getDataFolder(), string), clazz);
        }
        if (StringUtils.isOneOf("mongo", "mongodb", "mongodatabase")) {
            return null;
        }
        if (StringUtils.isOneOf("sql", "sqlite")) {
            return null;
        }
        MessageHandler.sendConsolePluginMessage("&4Invalid database type&8: &e" + string2);
        MessageHandler.sendConsolePluginMessage("&4Disabling the plugin...");
        skillsPro.onDisable();
        return null;
    }

    @EventHandler
    public void onLeaveEvent(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getPlayerDataManager().save(SkilledPlayer.getSkilledPlayer((OfflinePlayer)playerQuitEvent.getPlayer()));
        this.plugin.getPlayerDataManager().unload(playerQuitEvent.getPlayer().getUniqueId());
    }
}

