/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.managers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.skills.data.managers.Cosmetic;
import org.skills.gui.GUIConfig;
import org.skills.main.SkillsPro;

public class CosmeticCategory {
    public static final Map<String, CosmeticCategory> CATEGORIES = new HashMap<String, CosmeticCategory>();
    private final String name;
    private final String command;
    private final String description;
    private Map<String, Cosmetic> cosmetics;

    public CosmeticCategory(String string, String string2, String string3) {
        this.name = string;
        this.command = string2;
        this.description = string3;
        this.cosmetics = this.cosmetics;
    }

    public static void load(SkillsPro skillsPro) {
        Cosmetic.COSMETICS.clear();
        CATEGORIES.clear();
        ConfigurationSection configurationSection = skillsPro.getConfig().getConfigurationSection("cosmetics");
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            CosmeticCategory cosmeticCategory = new CosmeticCategory(string, configurationSection2.getString("command.name"), configurationSection2.getString("command.description"));
            HashMap<String, Cosmetic> hashMap = new HashMap<String, Cosmetic>();
            ConfigurationSection configurationSection3 = configurationSection2.getConfigurationSection("elements");
            for (String string2 : configurationSection3.getKeys(false)) {
                if (string2.equals("command")) continue;
                ConfigurationSection configurationSection4 = configurationSection3.getConfigurationSection(string2);
                Cosmetic cosmetic = new Cosmetic(cosmeticCategory, string2, configurationSection4.getString("displayname"), configurationSection4.getString("color"));
                Cosmetic.COSMETICS.put(string2, cosmetic);
                hashMap.put(string2, cosmetic);
            }
            cosmeticCategory.setCosmetics(hashMap);
            CATEGORIES.put(string, cosmeticCategory);
            GUIConfig.registerGUI((Plugin)skillsPro, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getCommand() {
        return this.command;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Cosmetic> getCosmetics() {
        return this.cosmetics;
    }

    public void setCosmetics(Map<String, Cosmetic> map) {
        this.cosmetics = map;
    }
}

