/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.FileManager;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.main.locale.LanguageManager;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.FastUUID;
import org.skills.utils.StringUtils;

public class OldSkillsConverter {
    private final File dbFolder;
    private final SkillsPro plugin;
    private final Path conv;

    public OldSkillsConverter(File file, SkillsPro skillsPro) {
        this.plugin = skillsPro;
        this.dbFolder = file;
        if (!file.exists()) {
            file.mkdirs();
        }
        this.conv = file.getParentFile().toPath().resolve("DONT DELETE ME V3.txt");
        this.convertDataV3();
    }

    private void convertDataV3() {
        if (Files.exists(this.conv, new LinkOption[0])) {
            return;
        }
        File[] fileArray = this.dbFolder.listFiles();
        if (fileArray.length == 0) {
            this.createConvFile(-1);
            return;
        }
        int n = 0;
        MessageHandler.sendConsolePluginMessage("&4Converting players data... This may take a few seconds");
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            MessageHandler.sendConsolePluginMessage("&cConverting player data for&8: &e" + file.getName());
            JSONParser jSONParser = new JSONParser();
            Path path = Paths.get(file.getPath(), new String[0]);
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                JSONObject jSONObject = (JSONObject)jSONParser.parse((Reader)bufferedReader);
                if (jSONObject.containsKey((Object)"skills")) continue;
                HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
                JSONObject jSONObject2 = new JSONObject();
                String string = (String)jSONObject.get((Object)"skill");
                jSONObject2.put((Object)"skill", (Object)string);
                jSONObject2.put((Object)"level", jSONObject.get((Object)"level"));
                jSONObject2.put((Object)"xp", jSONObject.get((Object)"xp"));
                jSONObject2.put((Object)"souls", jSONObject.get((Object)"souls"));
                jSONObject2.put((Object)"showReadyMessage", jSONObject.get((Object)"showReadyMessage"));
                jSONObject2.put((Object)"abilities", jSONObject.get((Object)"improvements"));
                jSONObject2.put((Object)"disabledAbilities", jSONObject.get((Object)"disabledAbilities"));
                jSONObject2.put((Object)"stats", jSONObject.get((Object)"stats"));
                hashMap.put(string, jSONObject2);
                jSONObject.put((Object)"skills", hashMap);
                try (Object object = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                    ((Writer)object).write(jSONObject.toJSONString());
                    ((BufferedWriter)object).flush();
                }
                object = file.getName().replace(".json", "");
                SkilledPlayer skilledPlayer = (SkilledPlayer)this.plugin.getPlayerDataManager().database.load((String)object);
                this.plugin.getPlayerDataManager().save(skilledPlayer);
                ++n;
            }
            catch (IOException | ParseException throwable) {
                throwable.printStackTrace();
            }
        }
        this.createConvFile(n);
        if (n != 0) {
            MessageHandler.sendConsolePluginMessage(" ");
            MessageHandler.sendConsolePluginMessage("&4A total of &e" + n + " &4players data have been converted. V2");
            MessageHandler.sendConsolePluginMessage("&4Note that this should only happen once. If this happened again make sure to report this issue.");
            MessageHandler.sendConsolePluginMessage(" ");
        }
    }

    private void convertDataV2() {
        if (Files.exists(this.conv, new LinkOption[0])) {
            return;
        }
        File[] fileArray = this.dbFolder.listFiles();
        if (fileArray.length == 0) {
            this.createConvFile(-1);
            return;
        }
        int n = 0;
        MessageHandler.sendConsolePluginMessage("&4Converting players data... This may take a few seconds");
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            MessageHandler.sendConsolePluginMessage("&cConverting player data for&8: &e" + file.getName());
            JSONParser jSONParser = new JSONParser();
            Path path = Paths.get(file.getPath(), new String[0]);
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                JSONObject jSONObject;
                JSONObject jSONObject2 = (JSONObject)jSONParser.parse((Reader)bufferedReader);
                if (!jSONObject2.containsKey((Object)"disabledAbilities")) {
                    jSONObject2.put((Object)"disabledAbilities", (Object)new JSONArray());
                }
                if (!jSONObject2.containsKey((Object)"lastSkillChange")) {
                    jSONObject2.put((Object)"lastSkillChange", (Object)0);
                }
                if (!jSONObject2.containsKey((Object)"friends")) {
                    jSONObject2.put((Object)"friends", (Object)new JSONArray());
                }
                if (!jSONObject2.containsKey((Object)"friendRequests")) {
                    jSONObject2.put((Object)"friendRequests", (Object)new JSONArray());
                }
                if (!jSONObject2.containsKey((Object)"healthScaling")) {
                    jSONObject2.put((Object)"healthScaling", (Object)-1);
                }
                if (!jSONObject2.containsKey((Object)"xp")) {
                    jSONObject2.put((Object)"xp", jSONObject2.get((Object)"exp"));
                    jSONObject2.remove((Object)"exp");
                }
                if (!(jSONObject = (JSONObject)jSONObject2.get((Object)"stats")).containsKey((Object)"PTS") && jSONObject.containsKey((Object)"points")) {
                    jSONObject.put((Object)"PTS", jSONObject.get((Object)"points"));
                }
                try (Object object = Files.newBufferedWriter(path, new OpenOption[0]);){
                    ((Writer)object).write(jSONObject2.toJSONString());
                    ((BufferedWriter)object).flush();
                }
                object = file.getName();
                UUID uUID = FastUUID.fromString(((String)object).substring(0, ((String)object).length() - 5));
                SkilledPlayer skilledPlayer = (SkilledPlayer)this.plugin.getPlayerDataManager().getData(uUID);
                this.plugin.getPlayerDataManager().save(skilledPlayer);
                ++n;
            }
            catch (IOException | ParseException throwable) {
                throwable.printStackTrace();
            }
        }
        this.createConvFile(n);
        if (n != 0) {
            MessageHandler.sendConsolePluginMessage(" ");
            MessageHandler.sendConsolePluginMessage("&4A total of &e" + n + " &4players data have been converted. V2");
            MessageHandler.sendConsolePluginMessage("&4Note that this should only happen once. If this happened again make sure to report this issue.");
            MessageHandler.sendConsolePluginMessage(" ");
        }
    }

    private void createConvFile(int n) {
        try {
            Files.createFile(this.conv, new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.conv, new OpenOption[0]);){
                bufferedWriter.write("This file is used to detect if a newer version of skills is being used.");
                bufferedWriter.newLine();
                bufferedWriter.write("This will avoid doing unnecessary checks during server startup and converting user's data for no reason.");
                bufferedWriter.newLine();
                bufferedWriter.write("This will probably be removed later.");
                bufferedWriter.newLine();
                bufferedWriter.write("Please DO NOT delete the file unless you know what you're doing.");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                if (n == -1) {
                    bufferedWriter.write("Status: You were not using an older version.");
                } else {
                    bufferedWriter.write("Status: Converted a total of " + n + " users from Skills v12");
                }
                bufferedWriter.newLine();
                bufferedWriter.write(StringUtils.getFullTime());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void validateConfigs() {
        if (!Files.exists(this.conv, new LinkOption[0])) {
            if (FileManager.isNew) {
                this.createConvFile(-1);
                return;
            }
        } else {
            return;
        }
        if (!LanguageManager.created || !FileManager.created) {
            MessageHandler.sendConsolePluginMessage("&c-----------------------------------------------------");
            MessageHandler.sendConsolePluginMessage("&cDetected &4&lSkills v12,&c taking a backup and reseting...");
            MessageHandler.sendConsolePluginMessage("&cIf this happened more than one time and you did not delete");
            MessageHandler.sendConsolePluginMessage("&cthe 'DONT DELETE ME' file, make sure to report this.");
            MessageHandler.sendConsolePluginMessage("&c-----------------------------------------------------");
        }
        File file = new File(this.dbFolder.getParent(), "config.yml");
        if (!FileManager.created) {
            MessageHandler.sendConsolePluginMessage("&cReseting config.yml...");
            file.delete();
            FileManager fileManager = new FileManager(this.plugin);
            fileManager.loadConfig();
        }
        if (!LanguageManager.created) {
            MessageHandler.sendConsolePluginMessage("&cReseting languages folder...");
            this.plugin.getLang().getFile().delete();
            this.plugin.getLang().load();
        }
    }

    private void convertData() {
        if (Files.exists(this.conv, new LinkOption[0])) {
            return;
        }
        int n = 0;
        MessageHandler.sendConsolePluginMessage("&4Converting players data... This may take a few seconds");
        for (File file : this.dbFolder.listFiles()) {
            if (!file.isFile() || file.getName().toLowerCase().endsWith(".json")) continue;
            MessageHandler.sendConsolePluginMessage("&cConverting player data for&8: &e" + file.getName());
            File file2 = new File(this.dbFolder, file.getName() + ".json");
            file.renameTo(file2);
            JSONParser jSONParser = new JSONParser();
            Path path = Paths.get(file2.getPath(), new String[0]);
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                JSONObject jSONObject = (JSONObject)jSONParser.parse((Reader)bufferedReader);
                Object object = jSONObject.get((Object)"uuid");
                if (object == null) {
                    SLogger.error("No ID element found. Skipping...");
                    continue;
                }
                jSONObject.remove((Object)"id");
                jSONObject.remove((Object)"uuid");
                String string = (String)jSONObject.get((Object)"skill");
                string = string.equalsIgnoreCase("none") ? "none" : StringUtils.capitalize(string);
                try (Object object2 = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                    ((Writer)object2).write(jSONObject.toJSONString());
                    ((BufferedWriter)object2).flush();
                }
                object2 = file.getName();
                UUID uUID = FastUUID.fromString(((String)object2).substring(0, ((String)object2).length() - 5));
                SkilledPlayer skilledPlayer = (SkilledPlayer)this.plugin.getPlayerDataManager().getData(uUID);
                this.plugin.getPlayerDataManager().save(skilledPlayer);
                ++n;
            }
            catch (IOException | ParseException throwable) {
                throwable.printStackTrace();
            }
        }
        this.createConvFile(n);
        if (n != 0) {
            MessageHandler.sendConsolePluginMessage(" ");
            MessageHandler.sendConsolePluginMessage("&4A total of &e" + n + " &4players data have been converted.");
            MessageHandler.sendConsolePluginMessage("&4Note that this should only happen once. If this happened again make sure to report this issue.");
            MessageHandler.sendConsolePluginMessage(" ");
        }
    }
}

