/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.skills.data.database.DataContainer;
import org.skills.data.database.SkillsDatabase;
import org.skills.data.database.json.AdapterEventType;
import org.skills.data.database.json.AdapterSkilledPlayer;
import org.skills.data.database.json.AdapterSkillsParty;
import org.skills.data.database.json.AdapterUUID;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsEventType;
import org.skills.party.SkillsParty;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class JsonDatabase<T extends DataContainer>
implements SkillsDatabase<T> {
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).registerTypeAdapter(UUID.class, (Object)new AdapterUUID()).registerTypeAdapter(SkilledPlayer.class, (Object)new AdapterSkilledPlayer()).registerTypeAdapter(SkillsParty.class, (Object)new AdapterSkillsParty()).registerTypeHierarchyAdapter(SkillsEventType.class, (Object)new AdapterEventType()).enableComplexMapKeySerialization().disableHtmlEscaping().setPrettyPrinting().create();
    private final Class<T> adapter;
    public Path dbFolder;
    private String[] keys;

    public JsonDatabase(File file, Class<T> clazz) {
        this.dbFolder = file.toPath();
        this.adapter = clazz;
        if (!Files.exists(this.dbFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dbFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static boolean verifyJson(String string) {
        return string.length() == 41 && StringUtils.countMatches((String)string, (String)"-") == 4 && string.toLowerCase().endsWith(".json");
    }

    @Override
    public void delete(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return;
        }
        Path path = this.dbFolder.resolve(string + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void save(T t) {
        String string = ((DataContainer)t).getKey() + ".json";
        Path path = this.dbFolder.resolve(string);
        String string2 = gson.toJson(t, this.adapter);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            bufferedWriter.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public T load(String string) {
        Object object;
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        String string2 = string + ".json";
        Path path = this.dbFolder.resolve(string2);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            object = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                String string3;
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string3);
                }
            }
            finally {
                if (object != null) {
                    ((BufferedReader)object).close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = (DataContainer)gson.fromJson(stringBuilder.toString(), this.adapter);
        ((DataContainer)object).setIdentifier(string);
        ((DataContainer)object).setSaveMeta();
        return (T)object;
    }

    @Override
    public boolean hasData(String string) {
        Path path = this.dbFolder.resolve(string + ".json");
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public @NonNull String[] getAllKeys() {
        if (this.keys != null) {
            return this.keys;
        }
        if (!Files.exists(this.dbFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dbFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return new String[0];
        }
        try {
            this.keys = (String[])Files.walk(this.dbFolder, new FileVisitOption[0]).map(path -> path.getFileName().toString()).filter(JsonDatabase::verifyJson).toArray(String[]::new);
            return this.keys;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new String[0];
        }
    }
}

