/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import org.skills.party.SkillsParty;
import org.skills.utils.FastUUID;

public class AdapterSkillsParty
implements JsonSerializer<SkillsParty>,
JsonDeserializer<SkillsParty> {
    public SkillsParty deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String string = jsonObject.get("name").getAsString();
        UUID uUID = FastUUID.fromString(jsonObject.get("leader").getAsString());
        SkillsParty skillsParty = new SkillsParty(uUID, string, true);
        skillsParty.setMembers((List)jsonDeserializationContext.deserialize(jsonObject.get("members"), new TypeToken<List<UUID>>(){}.getType()));
        return skillsParty;
    }

    public JsonElement serialize(SkillsParty skillsParty, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", skillsParty.getName());
        jsonObject.add("leader", jsonSerializationContext.serialize((Object)skillsParty.getLeader(), UUID.class));
        jsonObject.add("members", jsonSerializationContext.serialize(skillsParty.getMembers(), new TypeToken<List<UUID>>(){}.getType()));
        return jsonObject;
    }
}

