/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.PlayerSkill;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsEvent;
import org.skills.events.SkillsEventType;
import org.skills.party.PartyRank;
import org.skills.utils.FastUUID;

public class AdapterSkilledPlayer
implements JsonSerializer<SkilledPlayer>,
JsonDeserializer<SkilledPlayer> {
    public SkilledPlayer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        Object object;
        JsonElement jsonElement2;
        JsonElement jsonElement3;
        SkilledPlayer skilledPlayer = new SkilledPlayer(true);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Type type2 = new TypeToken<HashMap<String, PlayerSkill>>(){}.getType();
        skilledPlayer.setSkills((Map)jsonDeserializationContext.deserialize(jsonObject.get("skills"), type2));
        PlayerSkill playerSkill = skilledPlayer.getSkills().get(jsonObject.get("skill").getAsString());
        if (playerSkill == null) {
            playerSkill = new PlayerSkill("none");
        }
        skilledPlayer.setAbsoluteActiveSkill(playerSkill);
        JsonElement jsonElement4 = jsonObject.get("lastSkillChange");
        skilledPlayer.setLastSkillChange(jsonElement4 == null ? 0L : jsonElement4.getAsLong());
        Type type3 = new TypeToken<Set<UUID>>(){}.getType();
        Set set = (Set)jsonDeserializationContext.deserialize(jsonObject.get("friends"), type3);
        Set set2 = (Set)jsonDeserializationContext.deserialize(jsonObject.get("friendRequests"), type3);
        if (set != null) {
            skilledPlayer.setFriends(set);
        }
        if (set2 != null) {
            skilledPlayer.setFriendRequests(set2);
        }
        if ((jsonElement3 = jsonObject.get("healthScaling")) != null) {
            skilledPlayer.setHealthScaling(jsonElement3.getAsDouble());
        }
        if ((jsonElement2 = jsonObject.get("party")) != null) {
            skilledPlayer.setParty(FastUUID.fromString(jsonElement2.getAsString()));
        }
        skilledPlayer.setRank((PartyRank)((Object)jsonDeserializationContext.deserialize(jsonObject.get("rank"), PartyRank.class)));
        type2 = new TypeToken<HashMap<String, Integer>>(){}.getType();
        skilledPlayer.setMasteries((HashMap)jsonDeserializationContext.deserialize(jsonObject.get("masteries"), type2));
        type2 = new TypeToken<HashMap<SkillsEventType, SkillsEvent>>(){}.getType();
        Map map = (Map)jsonDeserializationContext.deserialize(jsonObject.get("bonuses"), type2);
        EnumMap<SkillsEventType, SkillsEvent> enumMap = new EnumMap<SkillsEventType, SkillsEvent>(SkillsEventType.class);
        for (Map.Entry entry : map.entrySet()) {
            object = (SkillsEventType)((Object)entry.getKey());
            if (object == null) {
                object = SkillsEventType.XP;
            }
            SkillsEvent skillsEvent = (SkillsEvent)entry.getValue();
            SkillsEvent object2 = new SkillsEvent(skillsEvent.getId(), (SkillsEventType)((Object)object), skillsEvent.getMultiplier(), skillsEvent.getTime(), TimeUnit.MILLISECONDS, skillsEvent.getStart());
            enumMap.put((SkillsEventType)((Object)object), object2);
        }
        skilledPlayer.setBonuses(enumMap);
        JsonElement jsonElement5 = jsonObject.get("cosmetics");
        if (jsonElement5 != null) {
            Map.Entry entry;
            type2 = new TypeToken<Map<String, String>>(){}.getType();
            entry = (Map)jsonDeserializationContext.deserialize(jsonElement5, type2);
            object = new HashMap();
            for (Map.Entry entry2 : entry.entrySet()) {
                object.put((String)entry2.getKey(), Cosmetic.COSMETICS.get(entry2.getValue()));
            }
            skilledPlayer.setCosmetics((Map<String, Cosmetic>)object);
        }
        return skilledPlayer;
    }

    public JsonElement serialize(SkilledPlayer skilledPlayer, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("skill", skilledPlayer.getSkillName());
        jsonObject.addProperty("lastSkillChange", (Number)skilledPlayer.getLastSkillChange());
        Type type2 = new TypeToken<Set<UUID>>(){}.getType();
        jsonObject.addProperty("healthScaling", (Number)skilledPlayer.getHealthScaling());
        jsonObject.add("friends", jsonSerializationContext.serialize(skilledPlayer.getFriends(), type2));
        jsonObject.add("friendRequests", jsonSerializationContext.serialize(skilledPlayer.getFriendRequests(), type2));
        if (skilledPlayer.hasParty()) {
            jsonObject.addProperty("party", FastUUID.toString(skilledPlayer.getPartyId()));
        }
        jsonObject.addProperty("rank", skilledPlayer.getRank() == null ? null : skilledPlayer.getRank().name());
        Type type3 = new TypeToken<HashMap<String, PlayerSkill>>(){}.getType();
        jsonObject.add("skills", jsonSerializationContext.serialize(skilledPlayer.getSkills(), type3));
        type3 = new TypeToken<HashMap<String, Integer>>(){}.getType();
        jsonObject.add("masteries", jsonSerializationContext.serialize(skilledPlayer.getMasteries(), type3));
        type3 = new TypeToken<HashMap<SkillsEventType, SkillsEvent>>(){}.getType();
        jsonObject.add("bonuses", jsonSerializationContext.serialize(skilledPlayer.getBonuses(), type3));
        JsonObject jsonObject2 = new JsonObject();
        for (Map.Entry<String, Cosmetic> entry : skilledPlayer.getCosmetics().entrySet()) {
            jsonObject2.addProperty(entry.getKey(), entry.getValue().getName());
        }
        jsonObject.add("cosmetics", (JsonElement)jsonObject2);
        return jsonObject;
    }
}

