/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skills.data.managers.PlayerSkill;
import org.skills.types.Stat;

public class AdapterPlayerSkill
implements JsonSerializer<PlayerSkill>,
JsonDeserializer<PlayerSkill> {
    public PlayerSkill deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String string = jsonObject.get("skill").getAsString();
        PlayerSkill playerSkill = new PlayerSkill(string);
        playerSkill.setLevel(jsonObject.get("level").getAsInt());
        playerSkill.setAbsoluteXP(jsonObject.get("xp").getAsDouble());
        playerSkill.setSouls(jsonObject.get("souls").getAsLong());
        playerSkill.setShowReadyMessage(jsonObject.get("showReadyMessage").getAsBoolean());
        playerSkill.setImprovements((HashMap)jsonDeserializationContext.deserialize(jsonObject.get("abilities"), new TypeToken<HashMap<String, HashMap<String, Integer>>>(){}.getType()));
        JsonObject jsonObject2 = jsonObject.get("stats").getAsJsonObject();
        for (Map.Entry entry : jsonObject2.entrySet()) {
            playerSkill.setStat((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
        }
        List list = (List)jsonDeserializationContext.deserialize(jsonObject.get("disabledAbilities"), new TypeToken<List<String>>(){}.getType());
        if (list == null) {
            list = new ArrayList();
        }
        playerSkill.setDisabledAbilities(list);
        return playerSkill;
    }

    public JsonElement serialize(PlayerSkill playerSkill, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("skill", playerSkill.getSkillName());
        jsonObject.addProperty("level", (Number)playerSkill.getLevel());
        jsonObject.addProperty("xp", (Number)playerSkill.getXP());
        jsonObject.addProperty("souls", (Number)playerSkill.getSouls());
        jsonObject.addProperty("showReadyMessage", Boolean.valueOf(playerSkill.showReadyMessage()));
        jsonObject.add("abilities", jsonSerializationContext.serialize(playerSkill.getImprovements(), new TypeToken<HashMap<String, HashMap<String, Integer>>>(){}.getType()));
        JsonObject jsonObject2 = new JsonObject();
        for (Stat stat : Stat.STATS) {
            jsonObject2.addProperty(stat.getDataNode(), (Number)playerSkill.getStat(stat));
        }
        jsonObject.add("stats", (JsonElement)jsonObject2);
        jsonObject.add("disabledAbilities", jsonSerializationContext.serialize(playerSkill.getDisabledAbilities(), new TypeToken<List<String>>(){}.getType()));
        return jsonObject;
    }
}

