/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data.database;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public abstract class DataContainer {
    private transient String saveMeta;

    protected static String compressUUID(UUID uUID) {
        return uUID == null ? "" : Long.toString(uUID.getLeastSignificantBits()) + uUID.getMostSignificantBits();
    }

    protected static String compressBoolean(boolean bl) {
        return bl ? "1" : "";
    }

    protected static <T> String compressCollecton(Collection<T> collection, Function<T, Object> function) {
        StringBuilder stringBuilder = new StringBuilder(collection.size() * collection.size());
        for (T t : collection) {
            stringBuilder.append(function.apply(t));
        }
        return stringBuilder.toString();
    }

    public abstract @NonNull String getKey();

    public String getSaveMeta() {
        return this.saveMeta;
    }

    public void setSaveMeta() {
        this.saveMeta = this.getCompressedData();
    }

    public boolean shouldSave() {
        String string = this.getCompressedData();
        if (!string.equals(this.saveMeta)) {
            this.saveMeta = string;
            return true;
        }
        return false;
    }

    public abstract @NonNull String getCompressedData();

    public abstract void setIdentifier(@NonNull String var1);
}

