/*
 * Decompiled with CFR 0.152.
 */
package org.skills.data;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;

public class AdapterYamlConfig {
    private final String resourcePath;
    private final File file;
    private YamlConfiguration config;

    public AdapterYamlConfig(File file, String string) {
        this.file = file;
        this.resourcePath = string;
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    public AdapterYamlConfig(File file) {
        this(file, file.getName());
    }

    public AdapterYamlConfig register() {
        if (!this.file.exists()) {
            this.config.options().copyDefaults(true);
            this.saveDefaultConfig(true);
            this.reloadConfig();
        }
        return this;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            SLogger.error("Error while attempting to save configuration file " + this.file.getName() + ": " + iOException.getMessage());
        }
    }

    public File getFile() {
        return this.file;
    }

    public void saveDefaultConfig(boolean bl) {
        SkillsPro.get().saveResource(this.resourcePath, bl);
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

