/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import java.util.Arrays;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.skills.main.locale.SkillsLang;

public class HandleSimpleSetters {
    private static final String[] expressions = new String[]{"add", "increase", "remove", "decrease", "set", "setraw"};

    protected static double eval(String[] stringArray, double d, int n) {
        String string = stringArray[1];
        double d2 = d;
        if (string.equalsIgnoreCase("add") || string.equalsIgnoreCase("increase")) {
            d2 += (double)n;
        }
        if (string.equalsIgnoreCase("remove") || string.equalsIgnoreCase("decrease")) {
            d2 -= (double)n;
        }
        if (string.equalsIgnoreCase("set") || string.equalsIgnoreCase("setraw")) {
            d2 = n;
        }
        return d2;
    }

    protected static boolean isAnySetter(String string) {
        return Arrays.stream(expressions).anyMatch(string2 -> string2.equalsIgnoreCase(string));
    }

    protected static String[] tabComplete(String string) {
        String[] stringArray = new String[]{"add", "decrease", "set"};
        if (string.isEmpty()) {
            return stringArray;
        }
        return (String[])Arrays.stream(stringArray).filter(string2 -> string2.startsWith(string.toLowerCase())).toArray(String[]::new);
    }

    protected static boolean handleInvalidSetter(CommandSender commandSender, String[] stringArray) {
        if (!HandleSimpleSetters.isAnySetter(stringArray[1])) {
            SkillsLang.Command_User_Invalid_Setter.sendMessage(commandSender, "%setter%", stringArray[1]);
            return true;
        }
        return false;
    }

    protected static void handleSuccess(CommandSender commandSender, SkillsLang skillsLang, OfflinePlayer offlinePlayer, double d, double d2) {
        skillsLang.sendMessage(commandSender, "%player%", offlinePlayer.getName(), "%amount%", d, "%new%", d2);
    }
}

