/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.user.HandleSimpleSetters;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;

public class CommandUserXP
extends SkillsCommand {
    public CommandUserXP(SkillsCommand skillsCommand) {
        super("xp", skillsCommand, SkillsLang.COMMAND_USER_XP_DESCRIPTION, false, "exp");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length >= 3) {
            int n;
            Object object;
            OfflinePlayer offlinePlayer;
            if (stringArray[0].equals("*")) {
                offlinePlayer = Bukkit.getOnlinePlayers().iterator();
                while (offlinePlayer.hasNext()) {
                    object = (Player)offlinePlayer.next();
                    SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)object);
                    if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                        return;
                    }
                    n = stringArray.length > 3 ? 3 : 2;
                    try {
                        double d;
                        double d2;
                        int n2 = Integer.parseInt(stringArray[n]);
                        if (stringArray.length > 3 && Boolean.parseBoolean(stringArray[2])) {
                            d2 = HandleSimpleSetters.eval(stringArray, skilledPlayer.getRawXP(), n2);
                            skilledPlayer.setRawXP(d2, false);
                            d = skilledPlayer.getRawXP();
                        } else {
                            d2 = HandleSimpleSetters.eval(stringArray, skilledPlayer.getXP(), n2);
                            if (d2 < 0.0) {
                                skilledPlayer.addXP(-skilledPlayer.getXP() + d2);
                            } else {
                                skilledPlayer.setXP(d2);
                            }
                            d = skilledPlayer.getXP();
                        }
                        HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_XP_SUCCESS, (OfflinePlayer)object, n2, d);
                        if (!object.isOnline()) continue;
                        HealthAndEnergyManager.updateStats((Player)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SkillsCommandHandler.sendNotNumber(commandSender, "XP", stringArray[n]);
                    }
                }
            }
            if ((offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0])) != null) {
                object = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                int n3 = stringArray.length > 3 ? 3 : 2;
                try {
                    double d;
                    n = Integer.parseInt(stringArray[n3]);
                    if (stringArray.length > 3 && Boolean.parseBoolean(stringArray[2])) {
                        double d3 = HandleSimpleSetters.eval(stringArray, ((SkilledPlayer)object).getRawXP(), n);
                        ((SkilledPlayer)object).setRawXP(d3, false);
                        d = ((SkilledPlayer)object).getRawXP();
                    } else {
                        double d4 = HandleSimpleSetters.eval(stringArray, ((SkilledPlayer)object).getXP(), n);
                        if (d4 < 0.0) {
                            ((SkilledPlayer)object).addXP(-((SkilledPlayer)object).getXP() + d4);
                        } else {
                            ((SkilledPlayer)object).setXP(d4);
                        }
                        d = ((SkilledPlayer)object).getXP();
                    }
                    HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_XP_SUCCESS, offlinePlayer, n, d);
                    if (offlinePlayer.isOnline()) {
                        HealthAndEnergyManager.updateStats((Player)offlinePlayer);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    SkillsCommandHandler.sendNotNumber(commandSender, "XP", stringArray[n3]);
                }
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user xp <player> <add/decrease/set> [raw] <amount>");
        }
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return HandleSimpleSetters.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<set raw?>", "true", "<amount>"};
        }
        if (stringArray.length == 4) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

