/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.user.HandleSimpleSetters;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.types.Stat;

public class CommandUserStats
extends SkillsCommand {
    public CommandUserStats(SkillsCommand skillsCommand) {
        super("stats", skillsCommand, SkillsLang.COMMAND_USER_STATS_DESCRIPTION, false, "stat", "statpoints", "statspoint");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length >= 3) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer != null && offlinePlayer.hasPlayedBefore()) {
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                try {
                    int n = Integer.parseInt(stringArray[2]);
                    int n2 = (int)HandleSimpleSetters.eval(stringArray, skilledPlayer.getPoints(), n);
                    skilledPlayer.setStat(Stat.POINTS, n2);
                    HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_STATPOINTS_SUCCESS, offlinePlayer, n, skilledPlayer.getPoints());
                }
                catch (NumberFormatException numberFormatException) {
                    SkillsCommandHandler.sendNotNumber(commandSender, "Stats", stringArray[2]);
                }
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user stats <player> <add/decrease/set> <amount>");
        }
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return HandleSimpleSetters.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

