/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.user.HandleSimpleSetters;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserSouls
extends SkillsCommand {
    public CommandUserSouls(SkillsCommand skillsCommand) {
        super("souls", skillsCommand, SkillsLang.COMMAND_USER_SOULS_DESCRIPTION, false, "soul");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length >= 3) {
            int n;
            Object object;
            OfflinePlayer offlinePlayer;
            if (stringArray[0].equals("*")) {
                offlinePlayer = Bukkit.getOnlinePlayers().iterator();
                while (offlinePlayer.hasNext()) {
                    object = (Player)offlinePlayer.next();
                    SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)object);
                    if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                        return;
                    }
                    try {
                        n = Integer.parseInt(stringArray[2]);
                        int n2 = (int)HandleSimpleSetters.eval(stringArray, skilledPlayer.getSouls(), n);
                        skilledPlayer.setSouls(n2);
                        HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_SOULS_SUCCESS, (OfflinePlayer)object, n, skilledPlayer.getSouls());
                    }
                    catch (NumberFormatException numberFormatException) {
                        SkillsCommandHandler.sendNotNumber(commandSender, "Soul", stringArray[2]);
                    }
                }
            }
            if ((offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0])) != null) {
                object = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                try {
                    int n3 = Integer.parseInt(stringArray[2]);
                    n = (int)HandleSimpleSetters.eval(stringArray, ((SkilledPlayer)object).getSouls(), n3);
                    ((SkilledPlayer)object).setSouls(n);
                    HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_SOULS_SUCCESS, offlinePlayer, n3, ((SkilledPlayer)object).getSouls());
                }
                catch (NumberFormatException numberFormatException) {
                    SkillsCommandHandler.sendNotNumber(commandSender, "Soul", stringArray[2]);
                }
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user soul <player> <add/decrease/set> <amount>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return HandleSimpleSetters.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

