/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.types.SkillManager;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserSkill
extends SkillsCommand {
    public CommandUserSkill(SkillsCommand skillsCommand) {
        super("skill", skillsCommand, SkillsLang.COMMAND_USER_SKILL_DESCRIPTION, false, "setskill");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length < 2) {
            SkillsCommandHandler.sendUsage(commandSender, "user setskill <player> <skill>");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1].toLowerCase();
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        if (!SkillManager.isSkillRegistered(string2)) {
            SkillsLang.COMMAND_USER_SKILL_NOT_SKILL.sendMessage(commandSender, "%skill%", string2);
            return;
        }
        skilledPlayer.setActiveSkill(SkillManager.getSkill(string2));
        SkillsLang.COMMAND_USER_SKILL_SUCCESS.sendMessage(commandSender, "%player%", string, "%skill%", string2);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            String[] stringArray2 = TabCompleteManager.getSkillTypes(stringArray[1]).toArray(new String[0]);
            if (stringArray[1].isEmpty()) {
                return stringArray2;
            }
            return (String[])Arrays.stream(stringArray2).filter(string -> string.toLowerCase().startsWith(stringArray[1].toLowerCase())).toArray(String[]::new);
        }
        return new String[0];
    }
}

