/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.commands.user.HandleSimpleSetters;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserMastery
extends SkillsCommand {
    public CommandUserMastery(SkillsCommand skillsCommand) {
        super("mastery", skillsCommand, SkillsLang.COMMAND_USER_MASTERY_DESCRIPTION, false, "masteries");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length >= 4) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer != null) {
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                Mastery mastery = MasteryManager.getMastery(stringArray[2]);
                if (mastery == null) {
                    SkillsLang.MASTERY_NOT_FOUND.sendMessage(commandSender, "%mastery%", stringArray[2]);
                    return;
                }
                try {
                    int n = Integer.parseInt(stringArray[3]);
                    int n2 = (int)HandleSimpleSetters.eval(stringArray, skilledPlayer.getMasteryLevel(mastery), n);
                    skilledPlayer.setMasteryLevel(mastery, n2);
                    SkillsLang.Command_User_Mastery_Set_Success.sendMessage(commandSender, "%player%", offlinePlayer.getName(), "%amount%", n + "", "%mastery%", mastery.getName(), "%new%", skilledPlayer.getMasteryLevel(mastery) + "");
                }
                catch (NumberFormatException numberFormatException) {
                    SkillsCommandHandler.sendNotNumber(commandSender, mastery.getName() + "'s level", stringArray[3]);
                }
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user mastery <player> <add/decrease/set> <mastery> <amount>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return HandleSimpleSetters.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return TabCompleteManager.getMasteries(stringArray[2]);
        }
        if (stringArray.length == 4) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

