/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.user.HandleSimpleSetters;
import org.skills.data.managers.PlayerDataManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.managers.LevelUp;
import org.skills.types.SkillScaling;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUserLevel
extends SkillsCommand {
    public CommandUserLevel(SkillsCommand skillsCommand) {
        super("level", skillsCommand, SkillsLang.COMMAND_USER_LEVEL_DESCRIPTION, false, "lvl", "lvls", "levels");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length >= 3) {
            if (stringArray[0].equals("*")) {
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    try {
                        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
                        int n = skilledPlayer.getLevel();
                        int n2 = Integer.parseInt(stringArray[2]);
                        int n3 = (int)HandleSimpleSetters.eval(stringArray, skilledPlayer.getLevel(), n2);
                        skilledPlayer.setLevel(n3);
                        if (skilledPlayer.getXP() > skilledPlayer.getLevelXP()) {
                            skilledPlayer.setAbsoluteXP(0.0);
                        }
                        if (n3 > n) {
                            boolean bl = false;
                            if (stringArray.length > 3 && stringArray[3].equalsIgnoreCase("silent")) {
                                bl = true;
                            }
                            if (!bl) {
                                int n4 = skilledPlayer.getLevel();
                                for (int i = 0; i < n4; ++i) {
                                    LevelUp levelUp = LevelUp.getProperties(n3).evaluate(skilledPlayer, i);
                                    levelUp.perform(skilledPlayer, "%next_maxxp%", skilledPlayer.getLevelXP(n3));
                                    if (!player.isOnline()) continue;
                                    levelUp.celebrate(player, this.plugin, n3);
                                }
                            }
                        }
                        PlayerDataManager.addLevel((OfflinePlayer)player, n3);
                        HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_LEVEL_SUCCESS, (OfflinePlayer)player, n2, skilledPlayer.getLevel());
                        if (!player.isOnline()) continue;
                        double d = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
                        if (skilledPlayer.getEnergy() > d) {
                            skilledPlayer.setEnergy(d);
                        }
                        HealthAndEnergyManager.updateStats(player);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SkillsCommandHandler.sendNotNumber(commandSender, "Level", stringArray[2]);
                    }
                }
                return;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer != null) {
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                try {
                    SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                    int n = skilledPlayer.getLevel();
                    int n5 = Integer.parseInt(stringArray[2]);
                    int n6 = (int)HandleSimpleSetters.eval(stringArray, skilledPlayer.getLevel(), n5);
                    int n7 = (int)skilledPlayer.getScaling(SkillScaling.MAX_LEVEL);
                    if (n == n7) {
                        if (offlinePlayer.isOnline()) {
                            SkillsLang.MAX_LEVEL.sendMessage((Player)offlinePlayer, new Object[0]);
                        }
                        return;
                    }
                    if (n6 >= n7) {
                        n6 = n7;
                    }
                    skilledPlayer.setLevel(n6);
                    if (skilledPlayer.getXP() > skilledPlayer.getLevelXP()) {
                        skilledPlayer.setAbsoluteXP(0.0);
                    }
                    if (n6 > n) {
                        boolean bl = false;
                        if (stringArray.length > 3 && stringArray[3].equalsIgnoreCase("silent")) {
                            bl = true;
                        }
                        if (!bl) {
                            int n8 = skilledPlayer.getLevel();
                            for (int i = 0; i < n8; ++i) {
                                LevelUp levelUp = LevelUp.getProperties(n6).evaluate(skilledPlayer, i);
                                levelUp.perform(skilledPlayer, "%next_maxxp%", skilledPlayer.getLevelXP(n6));
                                if (!offlinePlayer.isOnline()) continue;
                                levelUp.celebrate((Player)offlinePlayer, this.plugin, n6);
                            }
                        }
                    }
                    PlayerDataManager.addLevel(offlinePlayer, n6);
                    HandleSimpleSetters.handleSuccess(commandSender, SkillsLang.COMMAND_USER_LEVEL_SUCCESS, offlinePlayer, n5, skilledPlayer.getLevel());
                    if (offlinePlayer.isOnline()) {
                        HealthAndEnergyManager.updateStats((Player)offlinePlayer);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    SkillsCommandHandler.sendNotNumber(commandSender, "Level", stringArray[2]);
                }
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user level <player> <add/decrease/set> <amount>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return HandleSimpleSetters.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new String[]{"<amount>", "[silent]"};
        }
        if (stringArray.length == 4) {
            return new String[]{"silent"};
        }
        return new String[0];
    }
}

