/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.user;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.user.HandleSimpleSetters;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;

public class CommandUserImprove
extends SkillsCommand {
    public CommandUserImprove(SkillsCommand skillsCommand) {
        super("improve", skillsCommand, SkillsLang.COMMAND_USER_IMPROVE_DESCRIPTION, false, "improvement", "improvements", "upgrade", "upgrades", "ability", "abilities");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length >= 4) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer != null) {
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                if (HandleSimpleSetters.handleInvalidSetter(commandSender, stringArray)) {
                    return;
                }
                Ability ability = skilledPlayer.getSkill().getAbility(stringArray[2]);
                if (ability == null) {
                    SkillsLang.ABILITY_NOT_FOUND.sendMessage(commandSender, "%ability%", stringArray[2]);
                    return;
                }
                try {
                    int n = Integer.parseInt(stringArray[3]);
                    int n2 = (int)HandleSimpleSetters.eval(stringArray, skilledPlayer.getImprovementLevel(ability), n);
                    if (n2 < 0 || n2 > 3) {
                        SkillsLang.ABILITY_INVALID_LEVEL.sendMessage(commandSender, new Object[0]);
                        return;
                    }
                    skilledPlayer.setImprovement(ability, n2);
                    SkillsLang.COMMAND_USER_IMPROVEMENT_SUCCESS.sendMessage(commandSender, "%player%", offlinePlayer.getName(), "%amount%", n, "%ability%", ability.getName(), "%new%", skilledPlayer.getImprovementLevel(ability));
                }
                catch (NumberFormatException numberFormatException) {
                    SkillsCommandHandler.sendNotNumber(commandSender, ability.getName() + "'s level", stringArray[3]);
                }
            } else {
                SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "user improvement <player> <add/decrease/set> <improvement> <amount>");
        }
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return HandleSimpleSetters.tabComplete(stringArray[1]);
        }
        if (stringArray.length == 3) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
            if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
                return new String[0];
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
            if (skilledPlayer == null) {
                return new String[0];
            }
            return (String[])skilledPlayer.getSkill().getAbilities().stream().map(Ability::getName).filter(string -> string.startsWith(stringArray[2])).toArray(String[]::new);
        }
        if (stringArray.length == 4) {
            return new String[]{"<amount>"};
        }
        return new String[0];
    }
}

