/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.party;

import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.party.PartyRank;
import org.skills.party.SkillsParty;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandPartyLeader
extends SkillsCommand {
    public CommandPartyLeader(SkillsCommand skillsCommand) {
        super("leader", skillsCommand, SkillsLang.COMMAND_PARTY_LEADER_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        if (stringArray.length < 1) {
            SkillsCommandHandler.sendUsage(commandSender, "party leader <player>");
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasParty()) {
            SkillsLang.NO_PARTY.sendMessage(player, new Object[0]);
            return;
        }
        if (skilledPlayer.getRank() != PartyRank.LEADER) {
            SkillsLang.COMMAND_PARTY_LEADER_PERMISSION.sendMessage(player, new Object[0]);
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            return;
        }
        if (offlinePlayer.getUniqueId().equals(player.getUniqueId())) {
            SkillsLang.COMMAND_PARTY_LEADER_SELF.sendMessage(player, new Object[0]);
            return;
        }
        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        if (!skilledPlayer2.hasParty() || !skilledPlayer2.getPartyId().equals(skilledPlayer.getPartyId())) {
            SkillsLang.COMMAND_PARTY_LEADER_NOT_IN_PARTY.sendMessage(player, "%leader%", offlinePlayer.getName());
            return;
        }
        for (Player player2 : skilledPlayer.getParty().getOnlineMembers()) {
            SkillsLang.COMMAND_PARTY_LEADER_SET.sendMessage(player2, "%leader%", offlinePlayer.getName());
        }
        skilledPlayer.setRank(PartyRank.MODERATOR);
        skilledPlayer2.setRank(PartyRank.LEADER);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        SkilledPlayer skilledPlayer;
        if (commandSender instanceof Player && (skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)commandSender))).hasParty() && skilledPlayer.getRank() == PartyRank.LEADER) {
            SkillsParty skillsParty = skilledPlayer.getParty();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UUID uUID : skillsParty.getMembers()) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
                arrayList.add(offlinePlayer.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

