/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.party;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.party.PartyManager;
import org.skills.party.PartyRank;
import org.skills.party.SkillsParty;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandPartyInvite
extends SkillsCommand {
    public CommandPartyInvite(SkillsCommand skillsCommand) {
        super("invite", skillsCommand, SkillsLang.COMMAND_PARTY_INVITE_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        if (stringArray.length < 1) {
            SkillsCommandHandler.sendUsage(commandSender, "party invite <player>");
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasParty()) {
            SkillsLang.NO_PARTY.sendMessage(player, new Object[0]);
            return;
        }
        if (skilledPlayer.getRank() == PartyRank.MEMBER) {
            SkillsLang.COMMAND_PARTY_INVITE_PERMISSION.sendMessage(player, new Object[0]);
            return;
        }
        if (skilledPlayer.getFriends().size() >= SkillsConfig.PARTY_MAX_MEMBERS.getInt()) {
            SkillsLang.COMMAND_PARTY_INVITE_MAX.sendMessage(player, new Object[0]);
            return;
        }
        Player player2 = Bukkit.getPlayer((String)stringArray[0]);
        if (player2 == null) {
            SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            return;
        }
        if (player2.getUniqueId().equals(player.getUniqueId())) {
            SkillsLang.COMMAND_PARTY_INVITE_SELF.sendMessage(player, new Object[0]);
            return;
        }
        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2);
        if (skilledPlayer2.hasParty()) {
            SkillsLang.COMMAND_PARTY_INVITE_ARLEADY_PARTYING.sendMessage(player, "%invited%", player2.getName());
            return;
        }
        List<UUID> list = PartyManager.INVITES.get(player2.getUniqueId());
        if (list == null) {
            list = new ArrayList<UUID>();
        } else if (list.contains(skilledPlayer.getPartyId())) {
            SkillsLang.COMMAND_PARTY_INVITE_ALREADY_INVITED.sendMessage(player, new Object[0]);
            return;
        }
        SkillsLang.COMMAND_PARTY_INVITE_INVITED.sendMessage(player, "%invited%", player2.getName());
        if (player2.isOnline()) {
            SkillsLang.COMMAND_PARTY_INVITE_NOTIFICATION.sendMessage(player2, "%inviter%", player.getName(), "%party%", skilledPlayer.getParty().getName());
        }
        list.add(skilledPlayer.getPartyId());
        PartyManager.INVITES.put(player2.getUniqueId(), list);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
            if (PartyManager.INVITES.remove(player2.getUniqueId()) != null && player2.isOnline()) {
                SkillsLang.COMMAND_PARTY_INVITE_EXPIRED.sendMessage(player2, "%inviter%", player.getName());
            }
        }, 1200L);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        SkilledPlayer skilledPlayer;
        SkillsParty skillsParty;
        if (stringArray.length != 0 && commandSender instanceof Player && (skillsParty = (skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)commandSender))).getParty()) != null && skilledPlayer.getRank() != PartyRank.MEMBER) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getUniqueId().equals(((Player)commandSender).getUniqueId()) || skillsParty.getMembers().contains(player.getUniqueId()) || !stringArray[0].isEmpty() && !player.getName().startsWith(stringArray[0])) continue;
                arrayList.add(player.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

