/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.party;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.party.PartyManager;
import org.skills.party.SkillsParty;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandPartyAccept
extends SkillsCommand {
    public CommandPartyAccept(SkillsCommand skillsCommand) {
        super("accept", skillsCommand, SkillsLang.COMMAND_PARTY_ACCEPT_DESCRIPTION, "join");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.hasParty()) {
            SkillsLang.COMMAND_PARTY_ACCEPT_IN_PARTY.sendMessage(player, new Object[0]);
            return;
        }
        List<UUID> list = PartyManager.INVITES.get(player.getUniqueId());
        if (list == null) {
            SkillsLang.COMMAND_PARTY_ACCEPT_NOT_INVITED.sendMessage(player, new Object[0]);
            return;
        }
        SkillsParty skillsParty = null;
        if (stringArray.length == 0) {
            if (list.size() != 1) {
                SkillsLang.COMMAND_PARTY_ACCEPT_NAME.sendMessage(player, new Object[0]);
                return;
            }
            skillsParty = SkillsParty.getParty(list.get(0));
        } else {
            for (UUID uUID : list) {
                SkillsParty skillsParty2 = SkillsParty.getParty(uUID);
                if (!skillsParty2.getName().equalsIgnoreCase(stringArray[0])) continue;
                skillsParty = skillsParty2;
            }
        }
        if (skillsParty != null) {
            PartyManager.INVITES.remove(player.getUniqueId());
            skilledPlayer.joinParty(skillsParty);
            Iterator<UUID> iterator = skillsParty.getOnlineMembers().iterator();
            while (iterator.hasNext()) {
                Player player2 = (Player)iterator.next();
                SkillsLang.COMMAND_PARTY_ACCEPT_JOINED.sendMessage(player2, (OfflinePlayer)player, new Object[0]);
            }
            return;
        }
        if (stringArray.length == 0) {
            SkillsLang.COMMAND_PARTY_ACCEPT_NOT_INVITED.sendMessage(player, new Object[0]);
            return;
        }
        SkillsLang.COMMAND_PARTY_ACCEPT_NOT_INVITED_SPECIFIC.sendMessage(player, "%party%", stringArray[0]);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            List<UUID> list = PartyManager.INVITES.get(player.getUniqueId());
            if (list == null || list.isEmpty()) {
                return new String[0];
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            if (!skilledPlayer.hasParty()) {
                for (UUID uUID : list) {
                    SkillsParty skillsParty = SkillsParty.getParty(uUID);
                    if (skillsParty == null) continue;
                    arrayList.add(skillsParty.getName());
                }
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

