/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.types.Stat;

public class CommandStats
extends SkillsCommand {
    public CommandStats() {
        super("stats", SkillsLang.COMMAND_STATS_DESCRIPTION, false, "stat", "statpoints", "statspoint");
    }

    private static void openMenu(Player player, SkilledPlayer skilledPlayer, boolean bl) {
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "stats");
        for (Stat stat : Stat.STATS) {
            String string = stat.getNode().toLowerCase(Locale.ENGLISH);
            Object[] objectArray = new Object[]{"%max-level%", stat.getMaxLevel(), "%color%", stat.getColor(), "%level%", skilledPlayer.getStat(stat)};
            interactiveGUI.push(string + "-add", objectArray, () -> {
                CommandStats.addToStat(player, skilledPlayer, stat);
                CommandStats.openMenu(player, skilledPlayer, true);
            });
            interactiveGUI.push(string + "-add-all", objectArray, () -> {
                CommandStats.addAllPoints(player, skilledPlayer, stat);
                CommandStats.openMenu(player, skilledPlayer, true);
            });
        }
        interactiveGUI.push("distribute", () -> {
            CommandStats.distributeStats(player, skilledPlayer);
            CommandStats.openMenu(player, skilledPlayer, true);
        }, new Object[0]);
        interactiveGUI.push("reset", () -> CommandStats.reset(player, skilledPlayer), new Object[0]);
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player, bl);
    }

    public static void distributeStats(Player player, SkilledPlayer skilledPlayer) {
        Player player2 = skilledPlayer.getPlayer();
        int n = skilledPlayer.getPoints();
        if (n < 2) {
            SkillsLang.GUIS_STATMENU_STATPOINTS_NEEDED.sendMessage(player2, new Object[0]);
            return;
        }
        List<Stat> list = skilledPlayer.getSkill().getStats();
        if (list == null) {
            list = new ArrayList<Stat>(Stat.STATS);
            list.removeIf(stat -> Stat.isPoints(stat.getDataNode()));
        }
        int n2 = n / list.size();
        int n3 = 0;
        for (Stat stat2 : list) {
            int n4;
            int n5 = skilledPlayer.getStat(stat2);
            if (n5 + n2 <= stat2.getMaxLevel()) {
                skilledPlayer.setStat(stat2, n5 + n2);
                n4 = n2;
            } else {
                n4 = stat2.getMaxLevel() - n5;
                skilledPlayer.setStat(stat2, stat2.getMaxLevel());
            }
            n3 += n4;
            SkillsLang.GUIS_STATMENU_STATPOINTS_DISTRIBUTION.sendMessage(player2, "%amount%", n4, "%stat%", stat2.getName());
        }
        skilledPlayer.setStat(Stat.POINTS, n - n3);
        SkillsLang.GUIS_STATMENU_STATPOINTS_SPENT.parse(player2, new Object[]{"%amount%", n3});
    }

    public static void addAllPoints(Player player, SkilledPlayer skilledPlayer, Stat stat) {
        int n;
        int n2 = skilledPlayer.getPoints();
        if (n2 < 1) {
            SkillsLang.NOT_ENOUGH_STATPOINTS.sendMessage(skilledPlayer.getPlayer(), new Object[0]);
            return;
        }
        int n3 = stat.getMaxLevel();
        int n4 = skilledPlayer.getStat(stat);
        if (n4 + (n = n2) > n3) {
            n = n3 - n4;
        }
        int n5 = n2 - n;
        skilledPlayer.addStat(stat.getDataNode(), n);
        skilledPlayer.setStat(Stat.POINTS, n5);
    }

    private static void addToStat(Player player, SkilledPlayer skilledPlayer, Stat stat) {
        int n = skilledPlayer.getPoints();
        if (n < 1) {
            SkillsLang.NOT_ENOUGH_STATPOINTS.sendMessage(skilledPlayer.getPlayer(), new Object[0]);
            return;
        }
        int n2 = skilledPlayer.getStat(stat.getDataNode());
        if (n2 >= stat.getMaxLevel()) {
            return;
        }
        skilledPlayer.setStat(stat.getDataNode(), n2 + 1);
        skilledPlayer.setStat(Stat.POINTS, n - 1);
    }

    public static void reset(Player player, SkilledPlayer skilledPlayer) {
        Player player2 = skilledPlayer.getPlayer();
        int n = SkillsConfig.STATS_RESET_COST.getInt();
        long l = skilledPlayer.getSouls();
        long l2 = l - (long)n;
        if (l2 < 0L) {
            SkillsLang.NOT_ENOUGH_SOULS.sendMessage(player2, new Object[0]);
            return;
        }
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player2, "stats-reset-confirmation");
        interactiveGUI.push("reset", () -> {
            skilledPlayer.setSouls(l2);
            skilledPlayer.resetStats();
            SkillsLang.GUIS_STATMENU_RESET_MESSAGE.sendMessage(player, (OfflinePlayer)player2, new Object[0]);
            CommandStats.openMenu(player, skilledPlayer, true);
        }, new Object[0]);
        interactiveGUI.push("cancel", () -> CommandStats.openMenu(player, skilledPlayer, true), new Object[0]);
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player2);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (commandSender instanceof Player) {
            if (stringArray.length != 0) {
                if (commandSender.hasPermission("skills.command.stats.others")) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
                    if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
                        SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
                        return;
                    }
                    CommandStats.openMenu((Player)commandSender, SkilledPlayer.getSkilledPlayer(offlinePlayer), false);
                } else {
                    SkillsLang.COMMAND_STATS_OTHERS_PERMISSION.sendMessage(commandSender, new Object[0]);
                }
                return;
            }
            CommandStats.openMenu((Player)commandSender, SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)commandSender)), false);
        } else {
            SkillsLang.PLAYERS_ONLY.sendMessage(commandSender, new Object[0]);
        }
    }

    @Override
    public String[] tabComplete(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1 && commandSender instanceof Player && commandSender.hasPermission("skills.command.stats.others")) {
            return null;
        }
        return new String[0];
    }
}

