/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.FastUUID;
import org.skills.utils.MathUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class CommandStatistics
extends SkillsCommand {
    public CommandStatistics() {
        super("statistics", null, SkillsLang.COMMAND_STATISTICS_DESCRIPTION, false, "statistic", "percents");
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        arrayList.sort(Collections.reverseOrder(Map.Entry.comparingByValue()));
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return linkedHashMap;
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        CompletableFuture.runAsync(() -> {
            MessageHandler.sendMessage(commandSender, "&3Loading players data. This can take a few minutes...");
            Map<String, Integer> map = new HashMap();
            int n = 0;
            for (String string : this.plugin.getPlayerDataManager().database.getAllKeys()) {
                String string2 = string.substring(0, string.length() - 5);
                UUID uUID = FastUUID.fromString(string2);
                SkilledPlayer skilledPlayer = (SkilledPlayer)this.plugin.getPlayerDataManager().peek(uUID);
                Objects.requireNonNull(skilledPlayer.getSkill(), "Player skill cannot be null while handling statistics");
                String string3 = skilledPlayer.getSkill().getDisplayName();
                Objects.requireNonNull(string3, "Player skill displayname cannot be null while handling statistics");
                map.put(string3, map.getOrDefault(string3, 0) + 1);
                ++n;
            }
            MessageHandler.sendMessage(commandSender, "&3Loaded &e" + n + " &3player data.");
            map = CommandStatistics.sortByValue(map);
            for (Map.Entry entry : map.entrySet()) {
                double d = MathUtils.getPercent(((Integer)entry.getValue()).intValue(), n);
                d = MathUtils.roundToDigits(d, 3);
                MessageHandler.sendMessage(commandSender, "&3" + (String)entry.getKey() + "&8: &e" + d + "% &8(&7" + entry.getValue() + "&8)");
            }
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    @Override
    public @Nullable String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        return new String[0];
    }
}

