/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.XSound;

public class CommandSound
extends SkillsCommand {
    public CommandSound() {
        super("sound", null, SkillsLang.COMMAND_SOUND_DESCRIPTION, false, "play", "testsound");
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendMessage(commandSender, new Object[0]);
            return;
        }
        if (stringArray.length == 0) {
            SkillsCommandHandler.sendUsage(commandSender, "<sound> [volume] [pitch]");
            return;
        }
        String string = stringArray[0];
        Optional<XSound> optional = XSound.matchXSound(string);
        if (!optional.isPresent()) {
            MessageHandler.sendMessage(commandSender, "&4Could not find sound&8: &e" + string);
            return;
        }
        XSound xSound = optional.get();
        float f = 1.0f;
        float f2 = 0.5f;
        if (stringArray.length > 1) {
            f = NumberUtils.toFloat((String)stringArray[1], (float)1.0f);
            if (stringArray.length > 2) {
                f2 = NumberUtils.toFloat((String)stringArray[2], (float)1.0f);
            }
        }
        MessageHandler.sendMessage(commandSender, "&3Playing sound...");
        xSound.play(((Player)commandSender).getLocation(), f, f2);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return new String[0];
        }
        if (stringArray.length == 1) {
            return (String[])Arrays.stream(XSound.VALUES).map(Enum::name).filter(string -> string.contains(stringArray[0].toUpperCase(Locale.ENGLISH))).toArray(String[]::new);
        }
        if (stringArray.length == 2) {
            return new String[]{"[volume 0.0-\u221e]"};
        }
        if (stringArray.length == 3) {
            return new String[]{"[pitch 0.5-2.0]"};
        }
        return new String[0];
    }
}

