/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.commands.SkillsCommand;
import org.skills.commands.TabCompleteManager;
import org.skills.data.managers.PlayerSkill;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Skill;
import org.skills.types.SkillManager;
import org.skills.types.SkillScaling;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.XSound;

public class CommandSelect
extends SkillsCommand {
    public CommandSelect() {
        super("select", SkillsLang.COMMAND_SELECT_DESCRIPTION, false, "selectskill", "skillselect", "change");
    }

    public static void select(Player player, SkilledPlayer skilledPlayer, Skill skill) {
        int n;
        int n2;
        if (skilledPlayer.getSkill().equals(skill)) {
            SkillsLang.COMMAND_SELECT_ALREADY_CHOSEN.sendMessage(player, "%skill%", skill.getName());
            XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
            return;
        }
        if (!player.hasPermission("skills.select." + skill.getName().toLowerCase())) {
            SkillsLang.SKILL_NO_PERMISSION.sendMessage(player, "%skill%", skill.getName());
            XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
            return;
        }
        if (skilledPlayer.hasSkill() && !player.hasPermission("skills.change")) {
            SkillsLang.SKILL_OWNED_ERROR.sendMessage(player, new Object[0]);
            XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
            return;
        }
        if (!skill.isNone()) {
            n2 = (int)skill.getScaling(skilledPlayer, SkillScaling.REQUIRED_LEVEL);
            if (skilledPlayer.getLevel() < n2) {
                SkillsLang.SKILL_REQUIRED_LEVEL.sendMessage(player, "%level%", n2);
                XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                return;
            }
        }
        if (!skilledPlayer.canChangeSkill() && !player.hasPermission("skills.change.cooldownbypass")) {
            SkillsLang.SKILL_CHANGE_COOLDOWN_ERROR.sendMessage(player, "%cooldown%", skilledPlayer.getTimeLeftToChangeSkillString());
            XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
            return;
        }
        n2 = (int)skill.getScaling(skilledPlayer, SkillScaling.COST);
        if (skilledPlayer.getSouls() < (long)n2) {
            SkillsLang.SKILL_SELECT_COST.sendMessage(player, "%cost%", n2);
            return;
        }
        boolean bl = skilledPlayer.hasSkill();
        skilledPlayer.addSouls(-n2);
        skilledPlayer.setActiveSkill(skill);
        skilledPlayer.setEnergy(0.0);
        CommandSelect.performCommands(skilledPlayer, bl);
        if (SkillsConfig.STARTER_ENABLED.getBoolean() && (n = SkillsConfig.STARTER_ABILITIES_LEVEL.getInt()) > 0) {
            for (Ability ability : skilledPlayer.getSkill().getAbilities()) {
                skilledPlayer.setAbilityLevel(ability, n);
            }
        }
        if (bl) {
            if (SkillsConfig.SKILL_CHANGE_RESET_LEVEL.getBoolean()) {
                skilledPlayer.setAbsoluteXP(0.0);
                skilledPlayer.setLevel(0);
            }
            if (SkillsConfig.SKILL_CHANGE_RESET_SOULS.getBoolean()) {
                skilledPlayer.setSouls(0L);
            }
            if (SkillsConfig.SKILL_CHANGE_RESET_ABILITIES.getBoolean()) {
                skilledPlayer.getImprovements().clear();
                skilledPlayer.getDisabledAbilities().clear();
            }
            if (SkillsConfig.SKILL_CHANGE_RESET_STATS.getBoolean()) {
                skilledPlayer.getStats().clear();
            }
            if (SkillsConfig.SKILL_CHANGE_RESET_MASTERIES.getBoolean()) {
                skilledPlayer.getMasteries().clear();
            }
        }
        SkillsLang.SKILL_SELECTED.sendMessage(player, new Object[0]);
        HealthAndEnergyManager.updateStats(player);
    }

    public static void performCommands(SkilledPlayer skilledPlayer, boolean bl) {
        Player player = skilledPlayer.getPlayer();
        FileConfiguration fileConfiguration = skilledPlayer.getSkill().getAdapter().getConfig();
        List list = bl ? fileConfiguration.getStringList("commands-to-perform-upon-change") : fileConfiguration.getStringList("commands-to-perform-upon-select");
        for (String string : list) {
            ConsoleCommandSender consoleCommandSender = string.toUpperCase().startsWith("CONSOLE:") ? Bukkit.getConsoleSender() : player;
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            Bukkit.dispatchCommand((CommandSender)consoleCommandSender, (String)ServiceHandler.translatePlaceholders((OfflinePlayer)player, string));
        }
    }

    public static void openMenu(Player player, SkilledPlayer skilledPlayer) {
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "selector");
        for (Map.Entry<String, Skill> entry : SkillManager.getSkills().entrySet()) {
            Skill skill = entry.getValue();
            if (skill.isNone()) continue;
            PlayerSkill playerSkill = skilledPlayer.getSkills().get(skill.getName());
            interactiveGUI.push(entry.getKey(), () -> {
                player.closeInventory();
                CommandSelect.select(player, skilledPlayer, skill);
            }, "%cost%", (int)skill.getScaling(skilledPlayer, SkillScaling.COST), "%required-level%", (int)skill.getScaling(skilledPlayer, SkillScaling.REQUIRED_LEVEL), "%level%", playerSkill == null ? 0 : playerSkill.getLevel());
        }
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        Skill skill = null;
        if (stringArray.length > 0) {
            skill = SkillManager.getSkill(stringArray[0]);
        }
        if (skill == null) {
            CommandSelect.openMenu(player, skilledPlayer);
            return;
        }
        CommandSelect.select(player, skilledPlayer, skill);
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length > 1) {
            return new String[0];
        }
        return TabCompleteManager.getSkillTypes(stringArray[0]).toArray(new String[0]);
    }
}

