/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIOption;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;

public class CommandImprove
extends SkillsCommand {
    public CommandImprove() {
        super("improve", SkillsLang.COMMAND_IMPROVE_DESCRIPTION, "improvement", "improvements", "upgrade", "upgrades", "ability", "abilities");
    }

    public static void openMenu(Player player, SkilledPlayer skilledPlayer, int n, boolean bl) {
        int n2;
        Collection collection = skilledPlayer.getSkill().getAbilities();
        int n3 = collection.size();
        int n4 = n2 = n3 % 4 != 0 ? n3 / 4 + 1 : n3 / 4;
        if (n3 > 5) {
            collection = collection.stream().filter(ability -> !ability.getName().endsWith("passive")).skip(n * 4).limit(4L).collect(Collectors.toList());
            collection.add(skilledPlayer.getSkill().getAbilities().stream().filter(ability -> ability.getName().endsWith("passive")).findFirst().orElse(null));
        } else {
            n2 = 1;
        }
        int n5 = n2;
        Object[] objectArray = new Object[]{"%page%", n + 1, "%pages%", n2};
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "abilities", objectArray);
        interactiveGUI.push("previous-page", () -> {
            if (n == 0) {
                XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                return;
            }
            CommandImprove.openMenu(player, skilledPlayer, n - 1, true);
            XSound.ITEM_BOOK_PAGE_TURN.play((Entity)player);
        }, new Object[0]);
        interactiveGUI.push("next-page", () -> {
            if (n + 2 > n5) {
                XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                return;
            }
            CommandImprove.openMenu(player, skilledPlayer, n + 1, true);
            XSound.ITEM_BOOK_PAGE_TURN.play((Entity)player);
        }, new Object[0]);
        ArrayList<Integer> arrayList = null;
        for (Ability ability2 : collection) {
            Object object;
            int n6;
            Object object2;
            Object object32;
            boolean bl2 = ability2.getName().endsWith("passive");
            boolean bl3 = ability2.isPassive();
            int n7 = skilledPlayer.getImprovementLevel(ability2);
            String string = ability2.getExtra(skilledPlayer).getString("scaling");
            if (string != null) {
                try {
                    string = String.valueOf(MathUtils.roundToDigits(ability2.getScaling(skilledPlayer, new Object[0]), 2));
                }
                catch (ArithmeticException arithmeticException) {
                    string = ability2.getTranslatedScaling(skilledPlayer, ability2.getScalingEquation(skilledPlayer, "scaling"), new Object[0]);
                }
                string = Ability.getScalingColor(ability2.getExtra(skilledPlayer.getSkillName(), "scaling").getString()) + string;
            }
            if (string == null) {
                string = "";
            }
            ActiveAbility activeAbility = bl3 ? null : (ActiveAbility)ability2;
            Object[] objectArray2 = new Object[]{"%title%", ability2.getTitle(skilledPlayer), "%required-level%", ability2.getRequiredLevel(skilledPlayer), "%level%", n7, "%cost%", bl2 ? "" : Integer.valueOf(ability2.getCost(skilledPlayer)), "%activation%", bl3 ? "" : activeAbility.getActivationKey(skilledPlayer), "%cooldown%", bl3 ? 0.0 : activeAbility.getCooldown(skilledPlayer), "%energy%", bl3 ? 0.0 : activeAbility.getEnergy(skilledPlayer), "%disabled%", skilledPlayer.isAbilityDisabled(ability2), "%amount%", string};
            GUIOption gUIOption = interactiveGUI.getHolder("passive", objectArray2);
            GUIOption gUIOption2 = interactiveGUI.getHolder("ability", objectArray2);
            int n8 = gUIOption.getSlots().get(0);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>(gUIOption2.getSlots());
            }
            GUIOption gUIOption3 = bl3 ? (bl2 ? gUIOption : gUIOption2) : interactiveGUI.getHolder("active-ability", objectArray2);
            gUIOption3 = gUIOption3.clone();
            ItemStack itemStack = gUIOption3.getItem();
            ItemMeta itemMeta = gUIOption3.getItem().getItemMeta();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object32 : itemMeta.getLore()) {
                if (Strings.isNullOrEmpty((String)object32)) continue;
                object32 = MessageHandler.replace((String)object32, "%description%", ability2.getDescription(skilledPlayer));
                object2 = "";
                String[] stringArray = StringUtils.splitPreserveAllTokens((String)object32, (char)'\n');
                n6 = stringArray.length;
                for (object = 0; object < n6; ++object) {
                    String string2 = stringArray[object];
                    if (string2.isEmpty()) {
                        arrayList2.add(" ");
                        continue;
                    }
                    string2 = (String)object2 + MessageHandler.colorize(string2);
                    arrayList2.add(string2);
                    object2 = ChatColor.getLastColors((String)string2);
                }
            }
            itemMeta.setLore(arrayList2);
            gUIOption3.getItem().setItemMeta(itemMeta);
            objectArray2 = ability2.copyEdits(skilledPlayer, objectArray2);
            gUIOption3.defineVariables(interactiveGUI, Arrays.asList(objectArray2));
            int n9 = bl2 ? n8 : arrayList.remove(0);
            interactiveGUI.push(gUIOption3, itemStack, n9, objectArray2, null, new InteractiveGUI.ActionRunnable(ClickType.LEFT, () -> {
                if (bl2 || skilledPlayer.getImprovementLevel(ability2) >= 3) {
                    skilledPlayer.toggleAbility(ability2);
                    CommandImprove.openMenu(player, skilledPlayer, n, true);
                    XSound.BLOCK_END_PORTAL_FRAME_FILL.play((Entity)player);
                    return;
                }
                int n2 = ability2.getRequiredLevel(skilledPlayer);
                if (n2 > skilledPlayer.getLevel()) {
                    SkillsLang.ABILITY_REQUIRED_LEVEL.sendMessage(player, "%level%", n2);
                    XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                    return;
                }
                int n3 = ability2.getCost(skilledPlayer);
                long l = skilledPlayer.getSouls();
                if (l >= (long)n3) {
                    skilledPlayer.addImprovementLevel(ability2, 1);
                    skilledPlayer.setSouls(l - (long)n3);
                    SkillsLang.ABILITY_UPGRADED.sendMessage(player, new Object[0]);
                    XSound.BLOCK_ANVIL_USE.play((Entity)player);
                    CommandImprove.openMenu(player, skilledPlayer, n, true);
                } else {
                    SkillsLang.NOT_ENOUGH_SOULS.sendMessage(player, new Object[0]);
                    XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                }
            }), new InteractiveGUI.ActionRunnable(ClickType.RIGHT, () -> {
                int n2;
                if (skilledPlayer.getImprovementLevel(ability2) == 0 && (n2 = ability2.getRequiredLevel(skilledPlayer)) > skilledPlayer.getLevel()) {
                    SkillsLang.ABILITY_REQUIRED_LEVEL.sendMessage(player, "%level%", n2);
                    XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                    return;
                }
                skilledPlayer.toggleAbility(ability2);
                XSound.BLOCK_END_PORTAL_FRAME_FILL.play((Entity)player);
                CommandImprove.openMenu(player, skilledPlayer, n, true);
            }));
            if (bl2) continue;
            object2 = object32 = (Object)new int[]{n9 + 1, n9 + 2, n9 + 3};
            int n10 = ((Object)object2).length;
            for (n6 = 0; n6 < n10; ++n6) {
                object = object2[n6];
                if (n7 == 3) {
                    interactiveGUI.getInventory().setItem(object, CommandImprove.getDecal(XMaterial.GREEN_STAINED_GLASS_PANE));
                    continue;
                }
                if (n7 > 0) {
                    --n7;
                    interactiveGUI.getInventory().setItem(object, CommandImprove.getDecal(XMaterial.ORANGE_STAINED_GLASS_PANE));
                    continue;
                }
                interactiveGUI.getInventory().setItem(object, CommandImprove.getDecal(XMaterial.BLACK_STAINED_GLASS_PANE));
            }
            if (n7 == 3) {
                interactiveGUI.getInventory().setItem(n9 + 4, CommandImprove.getDecal(XMaterial.BLUE_STAINED_GLASS_PANE));
                continue;
            }
            interactiveGUI.getInventory().setItem(n9 + 4, CommandImprove.getDecal(XMaterial.GRAY_STAINED_GLASS_PANE));
        }
        interactiveGUI.dispose("ability", "active-ability", "passive");
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player, bl);
    }

    private static ItemStack getDecal(XMaterial xMaterial) {
        ItemStack itemStack = xMaterial.parseItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(" ");
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            if (!skilledPlayer.hasSkill()) {
                SkillsLang.NO_SKILL.sendMessage(player, new Object[0]);
                return;
            }
            CommandImprove.openMenu(player, skilledPlayer, 0, false);
        } else {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        return new String[0];
    }
}

