/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.general;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.skills.commands.SkillsCommand;
import org.skills.data.managers.Cosmetic;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class CommandCosmetic
extends SkillsCommand {
    private final CosmeticCategory category;

    public CommandCosmetic(CosmeticCategory cosmeticCategory) {
        super(cosmeticCategory.getCommand(), cosmeticCategory.getDescription(), new String[0]);
        this.category = cosmeticCategory;
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, this.category.getName());
        if (interactiveGUI == null) {
            MessageHandler.sendPlayerMessage(player, "&4Could not find GUI for &e" + this.category.getName() + " &4cosmetic category. Please contact the server's administrators.");
            return;
        }
        for (Cosmetic cosmetic : this.category.getCosmetics().values()) {
            interactiveGUI.push(cosmetic.getName(), () -> {
                skilledPlayer.getCosmetics().put(this.category.getName(), cosmetic);
                player.closeInventory();
            }, new Object[0]);
        }
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player);
    }

    @Override
    public @Nullable String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        return new String[0];
    }
}

