/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.friends;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandUnfriend
extends SkillsCommand {
    public CommandUnfriend() {
        super("unfriend", SkillsLang.COMMAND_UNFRIEND_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        if (stringArray.length < 1) {
            SkillsCommandHandler.sendUsage(commandSender, "unfriend <player>");
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[0]);
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            SkillsLang.PLAYER_NOT_FOUND.sendMessage(commandSender, "%name%", stringArray[0]);
            return;
        }
        Player player = (Player)commandSender;
        if (offlinePlayer.getUniqueId().equals(player.getUniqueId())) {
            SkillsLang.COMMAND_UNFRIEND_SELF.sendMessage(player, new Object[0]);
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.getFriends().contains(offlinePlayer.getUniqueId())) {
            SkillsLang.COMMAND_UNFRIEND_INVALID.sendMessage(player, "%removed%", offlinePlayer.getName());
            return;
        }
        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        skilledPlayer2.getFriends().remove(player.getUniqueId());
        skilledPlayer.getFriends().remove(offlinePlayer.getUniqueId());
        SkillsLang.COMMAND_UNFRIEND_REMOVED.sendMessage(player, "%removed%", offlinePlayer.getName());
        if (offlinePlayer.isOnline()) {
            SkillsLang.COMMAND_UNFRIEND_NOTIFICATION.sendMessage((Player)offlinePlayer, "%remover%", player.getName());
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandSender instanceof Player) {
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(((Player)commandSender).getUniqueId());
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getUniqueId().equals(((Player)commandSender).getUniqueId()) || !skilledPlayer.getFriends().contains(player.getUniqueId()) || stringArray[0].isEmpty() || !player.getName().startsWith(stringArray[0])) continue;
                arrayList.add(player.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

