/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.friends;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandFriend
extends SkillsCommand {
    public CommandFriend() {
        super("friend", SkillsLang.COMMAND_FRIEND_DESCRIPTION, new String[0]);
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            SkillsLang.PLAYERS_ONLY.sendConsoleMessage(new Object[0]);
            return;
        }
        if (stringArray.length < 1) {
            SkillsCommandHandler.sendUsage(commandSender, "friend <player>");
            return;
        }
        Player player = (Player)commandSender;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.getFriends().size() >= SkillsConfig.FRIENDS_MAX_FRIENDS.getInt()) {
            SkillsLang.COMMAND_FRIEND_MAX.sendMessage(player, new Object[0]);
            return;
        }
        OfflinePlayer offlinePlayer = this.getPlayer(commandSender, stringArray[0]);
        if (offlinePlayer == null) {
            return;
        }
        if (offlinePlayer.getUniqueId().equals(player.getUniqueId())) {
            SkillsLang.COMMAND_FRIEND_SELF.sendMessage(player, new Object[0]);
            return;
        }
        if (skilledPlayer.getFriends().contains(offlinePlayer.getUniqueId())) {
            SkillsLang.COMMAND_FRIEND_ALREADY_FRIENDS.sendMessage(player, "%invited%", offlinePlayer.getName());
            return;
        }
        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        if (skilledPlayer2.getFriendRequests().contains(player.getUniqueId())) {
            SkillsLang.COMMAND_FRIEND_ALREADY_SENT.sendMessage(player, "%invited%", offlinePlayer.getName());
            return;
        }
        if (skilledPlayer.getFriendRequests().contains(offlinePlayer.getUniqueId())) {
            if (offlinePlayer.isOnline()) {
                SkillsLang.COMMAND_FRIEND_FRIENDED.sendMessage((Player)offlinePlayer, "%friend%", player.getName());
            }
            SkillsLang.COMMAND_FRIEND_FRIENDED.sendMessage(player, "%friend%", offlinePlayer.getName());
            skilledPlayer2.getFriendRequests().remove(player.getUniqueId());
            skilledPlayer.getFriendRequests().remove(offlinePlayer.getUniqueId());
            skilledPlayer2.getFriends().add(player.getUniqueId());
            skilledPlayer.getFriends().add(offlinePlayer.getUniqueId());
            return;
        }
        skilledPlayer2.friendRequest(player);
        SkillsLang.COMMAND_FRIEND_REQUEST.sendMessage(player, "%invited%", offlinePlayer.getName());
        if (offlinePlayer.isOnline()) {
            SkillsLang.COMMAND_FRIEND_NOTIFICATION.sendMessage((Player)offlinePlayer, "%inviter%", player.getName());
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandSender instanceof Player && stringArray.length == 1) {
            Player player = (Player)commandSender;
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (player2.getUniqueId().equals(player.getUniqueId()) || skilledPlayer.getFriends().contains(player2.getUniqueId()) || !stringArray[0].isEmpty() && !player2.getName().startsWith(stringArray[0])) continue;
                arrayList.add(player2.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

