/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.bonuses;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsEventType;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandBonusTake
extends SkillsCommand {
    public CommandBonusTake(SkillsCommand skillsCommand) {
        super("take", skillsCommand, SkillsLang.COMMAND_BONUS_TAKE_DESCRIPTION, "remove", "delete");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 2) {
            OfflinePlayer offlinePlayer = this.getPlayer(commandSender, stringArray[0]);
            if (offlinePlayer == null) {
                return;
            }
            SkillsEventType skillsEventType = SkillsEventType.fromString(stringArray[1]);
            if (skillsEventType == null) {
                SkillsLang.COMMAND_BONUS_NOT_FOUND.sendMessage(commandSender, "%bonus%", stringArray[1]);
                return;
            }
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
            skilledPlayer.removeBonus(skillsEventType);
            SkillsLang.COMMAND_BONUS_TAKE_SUCCESS.sendMessage(commandSender, new Object[0]);
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "take <player> <xp/soul>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length > 2) {
            return new String[0];
        }
        if (stringArray.length == 2) {
            return new String[]{"soul", "XP"};
        }
        return null;
    }
}

