/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.types.SkillScaling;
import org.skills.utils.caffeine.cache.Cache;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.xseries.XMaterial;

public class VampirePassive
extends Ability {
    public VampirePassive() {
        super("Vampire", "passive");
    }

    @Override
    public void start() {
        VampirePassive.addTask(new BukkitRunnable(){
            final Cache<Integer, Integer> SUN = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    XMaterial xMaterial;
                    SkilledPlayer skilledPlayer;
                    long l;
                    World world;
                    GameMode gameMode;
                    if (player.isInvulnerable() || (gameMode = player.getGameMode()) == GameMode.SPECTATOR || gameMode == GameMode.CREATIVE || (world = player.getWorld()).getEnvironment() != World.Environment.NORMAL || (l = world.getTime()) >= 12300L && l <= 23850L || (skilledPlayer = VampirePassive.this.checkup(player)) == null) continue;
                    ItemStack itemStack = player.getInventory().getHelmet();
                    if (itemStack != null && (xMaterial = XMaterial.matchXMaterial(itemStack)).isOneOf(VampirePassive.this.getExtra(skilledPlayer, "light-level.prevents").getStringList())) {
                        return;
                    }
                    int n = (int)VampirePassive.this.getExtraScaling(skilledPlayer, "light-level.burn-activation", new Object[0]);
                    if (n <= 0) continue;
                    int n2 = player.getEyeLocation().getBlock().getLightFromSky();
                    int n5 = n2 -= 7;
                    int n6 = this.SUN.asMap().compute(player.getEntityId(), (n3, n4) -> n4 == null ? 1 : Math.max(Math.min(n, n4 + n5), 0));
                    if (n6 < n) continue;
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                        int n = (int)VampirePassive.this.getExtraScaling(skilledPlayer, "light-level.burn", new Object[0]);
                        player.setFireTicks(n * 20);
                        VampirePassive.this.applyEffects(skilledPlayer, "light-level.burn", (LivingEntity)player);
                    });
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 20L, 10L));
    }

    @EventHandler(ignoreCancelled=true)
    public void onVampireAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d = skilledPlayer.getEnergy();
        int n = (int)(d / this.getExtraScaling(skilledPlayer, "blood", entityDamageByEntityEvent) * this.getScaling(skilledPlayer, entityDamageByEntityEvent));
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + (double)n);
        skilledPlayer.chargeEnergy(skilledPlayer.getScaling(SkillScaling.ENERGY_REGEN) / 2.0);
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%blood%", this.translate(skilledPlayer, "blood")};
    }
}

