/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.types.SkillScaling;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class VampireBloodLust
extends Ability {
    public VampireBloodLust() {
        super("Vampire", "blood_lust");
    }

    @EventHandler(ignoreCancelled=true)
    public void onVampireHeal(EntityRegainHealthEvent entityRegainHealthEvent) {
        double d;
        if (entityRegainHealthEvent.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (!(entityRegainHealthEvent.getEntity() instanceof Player)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityRegainHealthEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityRegainHealthEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d2 = skilledPlayer.getEnergy();
        int n = (int)MathUtils.getPercent(d2, d = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY));
        if ((double)n < this.getExtraScaling(skilledPlayer, "energy", new Object[0])) {
            return;
        }
        entityRegainHealthEvent.setAmount(entityRegainHealthEvent.getAmount() + this.getExtraScaling(skilledPlayer, "regain", new Object[0]));
    }

    @EventHandler(ignoreCancelled=true)
    public void onVampireAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d2 = skilledPlayer.getEnergy();
        int n = (int)MathUtils.getPercent(d2, d = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY));
        if ((double)n < this.getExtraScaling(skilledPlayer, "energy", entityDamageByEntityEvent)) {
            return;
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, entityDamageByEntityEvent));
        if (skilledPlayer.getImprovementLevel(this) > 2 && MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chance", entityDamageByEntityEvent))) {
            VersionSupport.heal(player, this.getExtraScaling(skilledPlayer, "heal", entityDamageByEntityEvent));
            ParticleDisplay.colored(player.getLocation(), 20, 255, 0, 1.0f).spawn();
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%chance%", this.translate(skilledPlayer, "chance"), "%energy%", this.translate(skilledPlayer, "energy"), "%heal%", this.translate(skilledPlayer, "heal"), "%regain%", this.translate(skilledPlayer, "regain")};
    }
}

