/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.EntityEffect;
import org.bukkit.Particle;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vex;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.LastHitManager;
import org.skills.utils.FastUUID;
import org.skills.utils.Laser;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VampireBloodCircuit
extends ActiveAbility {
    private static final String MINION = "VAMPIRE_VEX";

    public VampireBloodCircuit() {
        super("vampire", "blood_circuit", false);
    }

    private static void killMinion(LivingEntity livingEntity) {
        livingEntity.getLocation().getWorld().spawnParticle(Particle.CLOUD, livingEntity.getLocation(), 100, 0.5, 0.5, 0.5, 0.05);
        livingEntity.setHealth(0.0);
    }

    private static Vex spawnMinion(Player player, LivingEntity livingEntity) {
        Vex vex = (Vex)player.getWorld().spawnEntity(player.getLocation(), EntityType.VEX);
        vex.setTarget(livingEntity);
        if (XMaterial.isNewVersion()) {
            vex.setCharging(true);
        }
        vex.setMetadata(MINION, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)livingEntity.getUniqueId()));
        vex.setRemoveWhenFarAway(true);
        vex.setCustomName(MessageHandler.colorize("&c" + player.getName() + " Minion"));
        vex.setCustomNameVisible(true);
        return vex;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVampireCircuit(final EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (((LivingEntity)entityDamageByEntityEvent.getEntity()).getHealth() - entityDamageByEntityEvent.getFinalDamage() < 1.0) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player2 = (Player)entityDamageByEntityEvent.getDamager();
        final SkilledPlayer skilledPlayer = this.activeCheckup(player2);
        if (skilledPlayer == null) {
            return;
        }
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            player.playEffect(EntityEffect.GUARDIAN_TARGET);
        }
        player = (EnderCrystal)player2.getWorld().spawnEntity(player2.getLocation().clone().add(0.0, 2.0, 0.0), EntityType.ENDER_CRYSTAL);
        player.setShowingBottom(false);
        XSound.ENTITY_ELDER_GUARDIAN_CURSE.play(player.getLocation());
        boolean bl = this.getExtra(skilledPlayer, "use-laser").getBoolean();
        Laser laser = null;
        if (bl) {
            try {
                laser = new Laser(player.getLocation().clone().add(0.0, 0.5, 0.0), livingEntity.getLocation(), -1, 16);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            laser.start((Plugin)SkillsPro.get());
        }
        Laser laser2 = laser;
        int n = skilledPlayer.getImprovementLevel(this);
        new BukkitRunnable((EnderCrystal)player, bl, laser2, player2, n){
            final double damageMod;
            final int inferno;
            final double distance;
            final Set<LivingEntity> minions;
            final ParticleDisplay particle;
            double damage;
            int duration;
            int repeat;
            int particleTimer;
            final /* synthetic */ EnderCrystal val$crystal;
            final /* synthetic */ boolean val$useLaser;
            final /* synthetic */ Laser val$finalLaser;
            final /* synthetic */ Player val$player;
            final /* synthetic */ int val$lvl;
            {
                this.val$crystal = enderCrystal;
                this.val$useLaser = bl;
                this.val$finalLaser = laser;
                this.val$player = player;
                this.val$lvl = n;
                this.damageMod = VampireBloodCircuit.this.getExtraScaling(skilledPlayer, "damage-modifier", entityDamageByEntityEvent);
                this.inferno = (int)VampireBloodCircuit.this.getExtraScaling(skilledPlayer, "inferno", entityDamageByEntityEvent);
                this.distance = VampireBloodCircuit.this.getExtraScaling(skilledPlayer, "distance", entityDamageByEntityEvent);
                this.minions = new HashSet<LivingEntity>();
                this.particle = ParticleDisplay.simple(null, Particle.DRAGON_BREATH).withCount(10).offset(0.1, 0.1, 0.1);
                this.damage = VampireBloodCircuit.this.getScaling(skilledPlayer, entityDamageByEntityEvent);
                this.duration = (int)(VampireBloodCircuit.this.getExtraScaling(skilledPlayer, "duration", entityDamageByEntityEvent) * 20.0);
                this.repeat = 0;
                this.particleTimer = 0;
            }

            public void run() {
                boolean bl;
                if (!livingEntity.isValid() || !this.val$crystal.isValid() || this.duration-- <= 0) {
                    this.cancel();
                    if (this.val$useLaser) {
                        this.val$finalLaser.stop();
                    }
                    this.val$crystal.getLocation().getWorld().spawnParticle(Particle.SPELL_WITCH, this.val$crystal.getLocation(), 200, 0.5, 0.5, 0.5, 0.05);
                    this.val$crystal.remove();
                    for (LivingEntity livingEntity2 : this.minions) {
                        VampireBloodCircuit.killMinion(livingEntity2);
                    }
                    return;
                }
                boolean bl2 = bl = livingEntity.getLocation().distance(this.val$crystal.getLocation()) > this.distance;
                if (this.val$useLaser) {
                    try {
                        if (bl) {
                            this.val$finalLaser.moveEnd(this.val$finalLaser.getStart());
                        } else {
                            this.val$finalLaser.moveEnd(livingEntity.getEyeLocation().add(0.0, -0.75, 0.0));
                        }
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                    }
                }
                if (bl) {
                    return;
                }
                if (this.particleTimer++ == 10) {
                    this.particleTimer = 0;
                    XParticle.line(this.val$crystal.getLocation().add(0.0, 0.5, 0.0), livingEntity.getEyeLocation(), 0.2, this.particle);
                }
                if (this.repeat++ == this.inferno) {
                    this.repeat = 0;
                    LastHitManager.damage(livingEntity, this.val$player, this.damage);
                    if (this.val$lvl > 1) {
                        VersionSupport.heal(this.val$player, this.damage);
                    }
                    this.damage += this.damageMod;
                    if (this.val$lvl > 2) {
                        this.minions.add((LivingEntity)VampireBloodCircuit.spawnMinion(this.val$player, livingEntity));
                    }
                    try {
                        if (this.val$useLaser) {
                            this.val$finalLaser.callColorChange();
                        }
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                    }
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 1L, 1L);
    }

    @EventHandler
    public void onTargetChange(EntityTargetEvent entityTargetEvent) {
        if (!XMaterial.supports(11) || entityTargetEvent.getEntity().getType() != EntityType.VEX) {
            return;
        }
        Entity entity = entityTargetEvent.getEntity();
        List list = entity.getMetadata(MINION);
        if (list.isEmpty()) {
            return;
        }
        UUID uUID = FastUUID.fromString(((MetadataValue)list.get(0)).asString());
        if (entityTargetEvent.getTarget() == null || !uUID.equals(entityTargetEvent.getTarget().getUniqueId())) {
            for (LivingEntity livingEntity : entity.getLocation().getWorld().getLivingEntities()) {
                if (!uUID.equals(livingEntity.getUniqueId())) continue;
                entityTargetEvent.setTarget((Entity)livingEntity);
                break;
            }
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%damage-modifier%", this.translate(skilledPlayer, "damage-modifier"), "%duration%", this.translate(skilledPlayer, "duration"), "%inferno%", this.translate(skilledPlayer, "inferno"), "%distance%", this.translate(skilledPlayer, "distance")};
    }
}

