/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class VampireBleed
extends Ability {
    public VampireBleed() {
        super("Vampire", "bleed");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onVampireAttack(final EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        final Player player = (Player)entityDamageByEntityEvent.getDamager();
        final SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        final ParticleDisplay particleDisplay = ParticleDisplay.colored(player.getLocation(), 0, 255, 0, 1.0f);
        particleDisplay.count = 30;
        particleDisplay.offset(0.5, 0.5, 0.5);
        final ParticleDisplay particleDisplay2 = ParticleDisplay.colored(player.getLocation(), 255, 0, 0, 1.0f);
        particleDisplay2.count = 30;
        particleDisplay2.offset(0.5, 0.5, 0.5);
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (!MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chance", "damage", entityDamageByEntityEvent.getDamage()))) {
            return;
        }
        new BukkitRunnable(){
            final int duration;
            final double scaling;
            int repeat;
            {
                this.duration = (int)VampireBleed.this.getExtraScaling(skilledPlayer, "duration", entityDamageByEntityEvent);
                this.scaling = VampireBleed.this.getScaling(skilledPlayer, entityDamageByEntityEvent);
                this.repeat = 0;
            }

            public void run() {
                if (!livingEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.repeat;
                particleDisplay.spawn(player.getLocation());
                particleDisplay2.spawn(livingEntity.getLocation());
                livingEntity.damage(this.scaling);
                VersionSupport.heal(player, this.scaling);
                if (this.repeat > this.duration) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 10L);
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%chance%", this.getExtraScaling(skilledPlayer, "chance", new Object[0])};
    }
}

