/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.swordsman;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;

public class SwordsmanDodge
extends Ability {
    public SwordsmanDodge() {
        super("Swordsman", "dodge");
    }

    @EventHandler(ignoreCancelled=true)
    public void onSwordsmanDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(itemStack);
        if (!xMaterial.isOneOf(this.getExtra(skilledPlayer).getStringList("weapons"))) {
            return;
        }
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, entityDamageByEntityEvent))) {
            entityDamageByEntityEvent.setCancelled(true);
            SkillsLang.Skill_Swordsman_Dodge_Message.sendMessage(player, new Object[0]);
            if (entityDamageByEntityEvent.getDamager() instanceof Player) {
                SkillsLang.Skill_Swordsman_Dodge_Opponent_Message.sendMessage((CommandSender)entityDamageByEntityEvent.getDamager(), new Object[0]);
            }
        }
    }
}

