/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.swordsman;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class SwordsmanDash
extends ActiveAbility {
    public SwordsmanDash() {
        super("Swordsman", "dash", true);
    }

    @Override
    protected void useSkill(final Player player) {
        final SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        new BukkitRunnable(){
            final ParticleDisplay display = ParticleDisplay.simple(null, Particle.CLOUD).withCount(10).offset(0.5, 0.2, 0.5);
            int repeat = 20;

            public void run() {
                this.display.spawn(player.getLocation());
                if (this.repeat-- == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
        final int n = skilledPlayer.getImprovementLevel(this);
        final int n2 = (int)this.getExtraScaling(skilledPlayer, "charge.level", new Object[0]);
        if (n >= n2) {
            new BukkitRunnable(){
                final List<PotionEffect> effects;
                final double range;
                final double kb;
                final double damage;
                final ParticleDisplay masterDisplay;
                final Set<UUID> targets;
                int repeat;
                {
                    this.effects = SwordsmanDash.this.getEffects(skilledPlayer, "effects");
                    this.range = SwordsmanDash.this.getExtraScaling(skilledPlayer, "range", new Object[0]);
                    this.kb = SwordsmanDash.this.getExtraScaling(skilledPlayer, "charge.knockback", new Object[0]);
                    this.damage = SwordsmanDash.this.getExtraScaling(skilledPlayer, "charge.damage", new Object[0]);
                    this.masterDisplay = ParticleDisplay.simple(null, Particle.SWEEP_ATTACK).withCount(10).offset(1.0, 1.0, 1.0);
                    this.targets = new HashSet<UUID>();
                    this.repeat = 20;
                }

                public void run() {
                    for (Entity entity : player.getNearbyEntities(this.range, this.range, this.range)) {
                        Player player2;
                        GameMode gameMode;
                        LivingEntity livingEntity;
                        if (!(entity instanceof LivingEntity) || entity.getType() == EntityType.ARMOR_STAND || (livingEntity = (LivingEntity)entity).isInvulnerable() || this.targets.contains(entity.getUniqueId()) || livingEntity instanceof Player && ((gameMode = (player2 = (Player)livingEntity).getGameMode()) == GameMode.CREATIVE || gameMode == GameMode.SPECTATOR || !ServiceHandler.canFight((Entity)player, (Entity)player2))) continue;
                        this.targets.add(entity.getUniqueId());
                        livingEntity.addPotionEffects(this.effects);
                        if (n >= n2) {
                            livingEntity.setVelocity(livingEntity.getVelocity().subtract(player.getVelocity()).multiply(this.kb));
                        }
                        livingEntity.damage(this.damage, (Entity)player);
                        XSound.ENTITY_PLAYER_ATTACK_SWEEP.play(livingEntity.getLocation());
                        this.masterDisplay.spawn(livingEntity.getEyeLocation());
                    }
                    if ((this.repeat -= 2) == 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 2L);
        }
        Vector vector = new Vector(player.getLocation().getDirection().getX(), 0.0, player.getLocation().getDirection().getZ()).normalize();
        double d = this.getScaling(skilledPlayer, new Object[0]);
        player.setVelocity(vector.multiply(d));
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%damage%", this.translate(skilledPlayer, "charge.damage"), "%knockback%", this.translate(skilledPlayer, "charge.knockback"), "%range%", this.translate(skilledPlayer, "range")};
    }
}

