/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.swordsman;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.Cooldown;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class SwordsmanAnnihilation
extends ActiveAbility {
    private static final String META = "Annihilation";
    private static final XMaterial[] SWORDS;
    private static final Map<Integer, Runnable> CANCELS;

    public SwordsmanAnnihilation() {
        super("Swordsman", "annihilation", true);
    }

    private static double distance(Location location, Location location2) {
        World world = location2.getWorld();
        if (!world.getName().equals(location.getWorld().getName())) {
            return Double.MAX_VALUE;
        }
        double d = NumberConversions.square((double)(location.getX() - location2.getX())) + NumberConversions.square((double)(location.getY() - location2.getY())) + NumberConversions.square((double)(location.getZ() - location2.getZ()));
        return Math.sqrt(d);
    }

    private static void cancelAnnihilation(Player player) {
        Runnable runnable = CANCELS.remove(player.getEntityId());
        if (runnable != null) {
            runnable.run();
        }
    }

    @EventHandler
    public void onAttack(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        final Player player = playerInteractEvent.getPlayer();
        if (!player.hasMetadata(META)) {
            return;
        }
        if (Cooldown.isInCooldown(player.getUniqueId(), META)) {
            return;
        }
        final SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        new Cooldown(player.getUniqueId(), META, (long)this.getExtraScaling(skilledPlayer, "throw.cooldown", new Object[0]), TimeUnit.SECONDS);
        ParticleDisplay particleDisplay = ParticleDisplay.simple(null, Particle.CLOUD).offset(0.1, 0.1, 0.1).withCount(10);
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        final ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        XSound.ENTITY_WITHER_SHOOT.play(player.getLocation(), 3.0f, 0.5f);
        for (XMaterial xMaterial : SWORDS) {
            Location location = player.getEyeLocation().add(threadLocalRandom.nextDouble(-2.0, 2.0), threadLocalRandom.nextDouble(0.5, 2.0), threadLocalRandom.nextDouble(-2.0, 2.0));
            Item item = player.getWorld().dropItem(location, xMaterial.parseItem());
            item.setGravity(false);
            item.setPickupDelay(Integer.MAX_VALUE);
            particleDisplay.spawn(location);
            keySetView.add(item);
        }
        SwordsmanAnnihilation.addAllEntities(keySetView);
        final Location location = player.getEyeLocation();
        final Vector vector = player.getLocation().getDirection();
        vector.normalize();
        new BukkitRunnable(){
            final double xDir;
            final double yDir;
            final double dist;
            final ParticleDisplay display;
            double rate;
            double radius;
            boolean reverse;
            double theta;
            {
                this.xDir = Math.toRadians(location.getPitch() + 90.0f);
                this.yDir = Math.toRadians(-location.getYaw());
                this.dist = Math.PI * 2 / (double)keySetView.size();
                this.display = ParticleDisplay.simple(null, Particle.DRAGON_BREATH);
                this.rate = 1.0;
                this.radius = 1.0;
                this.reverse = false;
                this.theta = 0.0;
            }

            public void run() {
                double d = 0.0;
                Vector vector4 = vector.clone().multiply(this.rate);
                final Location location2 = location.clone().add(vector4);
                new BukkitRunnable(){
                    final double damage;
                    final ParticleDisplay sweep;
                    {
                        this.damage = SwordsmanAnnihilation.this.getExtraScaling(skilledPlayer, "throw.damage", new Object[0]);
                        this.sweep = ParticleDisplay.simple(null, Particle.SWEEP_ATTACK).offset(0.3, 0.3, 0.3).withCount(5);
                    }

                    public void run() {
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        for (Entity entity : location2.getWorld().getNearbyEntities(location2, 3.0, 3.0, 3.0)) {
                            Player player;
                            if (EntityUtil.isInvalidEntity(entity) || hashSet.contains(entity.getEntityId()) || entity instanceof Player && ((player = (Player)entity).getEntityId() == player.getEntityId() || !ServiceHandler.canFight((Entity)player, (Entity)player))) continue;
                            player = (LivingEntity)entity;
                            player.damage(this.damage, (Entity)player);
                            XSound.ENTITY_PLAYER_ATTACK_SWEEP.play((Entity)player, 5.0f, 0.5f);
                            this.sweep.spawn(player.getEyeLocation());
                            hashSet.add(entity.getEntityId());
                        }
                    }
                }.runTask((Plugin)SkillsPro.get());
                for (Item item : keySetView) {
                    double d2 = this.radius * Math.cos(this.theta + d);
                    double d3 = this.radius * Math.sin(this.theta + d);
                    Vector vector2 = new Vector(d2, 0.0, d3);
                    XParticle.rotateAround(vector2, this.xDir, this.yDir, 0.0);
                    vector2 = vector4.clone().add(vector2);
                    Vector vector3 = location.toVector().add(vector2);
                    item.setVelocity(vector3.subtract(item.getLocation().toVector()));
                    this.display.spawn(item.getLocation());
                    d += this.dist;
                }
                if (this.reverse) {
                    this.radius -= 0.05;
                    if (this.radius <= 1.0) {
                        this.reverse = false;
                    }
                } else {
                    this.radius += 0.05;
                    if (this.radius >= 2.0) {
                        this.reverse = true;
                    }
                }
                this.theta += 0.15707963267948966;
                this.rate += 0.5;
                if (this.rate > 20.0) {
                    this.cancel();
                    for (Item item : keySetView) {
                        item.remove();
                        Ability.removeEntity((Entity)item);
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
    }

    @Override
    protected void useSkill(final Player player) {
        final SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        final ParticleDisplay particleDisplay = ParticleDisplay.simple(null, Particle.CLOUD).offset(0.1, 0.1, 0.1).withCount(10);
        final ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        new BukkitRunnable(){
            final ThreadLocalRandom random = ThreadLocalRandom.current();
            int i = 0;

            public void run() {
                XMaterial xMaterial = SWORDS[this.i];
                Location location = player.getEyeLocation().add(this.random.nextDouble(-2.0, 2.0), this.random.nextDouble(0.5, 2.0), this.random.nextDouble(-2.0, 2.0));
                particleDisplay.spawn(location);
                Item item = player.getWorld().dropItem(location, xMaterial.parseItem());
                item.setGravity(false);
                item.setPickupDelay(Integer.MAX_VALUE);
                keySetView.add(item);
                if (++this.i == SWORDS.length) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 1L, 20L);
        SwordsmanAnnihilation.addAllEntities(keySetView);
        player.setMetadata(META, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), keySetView));
        final long l = (long)this.getExtraScaling(skilledPlayer, "duration", new Object[0]) * 20L;
        XSound.MUSIC_DISC_FAR.play((Entity)player, 10.0f, 0.5f);
        final BukkitTask bukkitTask = XParticle.blackhole(SkillsPro.get(), 5, 2.0, 30.0, 1, (int)l, ParticleDisplay.simple(player.getLocation(), Particle.FLAME).withEntity((Entity)player));
        final HashMap hashMap = new HashMap();
        final HashSet hashSet = new HashSet();
        double d = Math.PI;
        final ArrayList arrayList = new ArrayList(Arrays.asList(new double[4], {0.0, 1.5707963267948966, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.7853981633974483}, {0.0, 0.0, 0.0, 1.5707963267948966}, {0.0, 0.7853981633974483, 0.0, 0.0}, {0.0, 0.7853981633974483, 1.5707963267948966, 0.7853981633974483}));
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        BukkitTask bukkitTask2 = new BukkitRunnable(){
            final double radius = 2.0;
            final double rateDiv = 0.10471975511965977;
            final double rotMin = 0.031415926535897934;
            final double rotMax = 0.06283185307179587;
            final ParticleDisplay display = ParticleDisplay.simple(null, Particle.SPELL_WITCH);
            final ThreadLocalRandom random = ThreadLocalRandom.current();
            long dur = l;

            public void run() {
                int n = 0;
                for (Entity entity : keySetView) {
                    if (hashMap.containsValue(entity.getEntityId())) continue;
                    double[] dArray = (double[])arrayList.get(n);
                    double d = dArray[0];
                    double d2 = 2.0 * Math.cos(d);
                    double d3 = 2.0 * Math.sin(d);
                    Vector vector = new Vector(d2, 0.0, d3);
                    XParticle.rotateAround(vector, dArray[1], dArray[2], dArray[3]);
                    entity.setVelocity(player.getEyeLocation().toVector().add(vector).subtract(entity.getLocation().toVector()));
                    this.display.spawn(entity.getLocation());
                    dArray[0] = dArray[0] + 0.10471975511965977;
                    dArray[1] = dArray[1] + this.random.nextDouble(0.031415926535897934, 0.06283185307179587);
                    dArray[2] = dArray[2] + this.random.nextDouble(0.031415926535897934, 0.06283185307179587);
                    dArray[3] = dArray[3] + this.random.nextDouble(0.031415926535897934, 0.06283185307179587);
                    ++n;
                }
                if (--this.dur <= 0L) {
                    this.cancel();
                    bukkitTask.cancel();
                    atomicBoolean.set(true);
                    CANCELS.remove(player.getEntityId());
                    player.stopSound(XSound.MUSIC_DISC_FAR.parseSound());
                    for (Entity entity : keySetView) {
                        entity.remove();
                        particleDisplay.spawn(entity.getLocation());
                        player.removeMetadata(SwordsmanAnnihilation.META, (Plugin)SkillsPro.get());
                        Ability.removeEntity(entity);
                    }
                    XSound.BLOCK_BEACON_DEACTIVATE.play(player.getLocation(), 10.0f, 0.5f);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
        Runnable runnable = () -> {
            bukkitTask.cancel();
            bukkitTask2.cancel();
            atomicBoolean.set(true);
            CANCELS.remove(player.getEntityId());
            player.stopSound(XSound.MUSIC_DISC_FAR.parseSound());
            for (Entity entity : keySetView) {
                entity.remove();
                particleDisplay.spawn(entity.getLocation());
                player.removeMetadata(META, (Plugin)SkillsPro.get());
                SwordsmanAnnihilation.removeEntity(entity);
            }
            XSound.BLOCK_BEACON_DEACTIVATE.play(player.getLocation(), 10.0f, 0.5f);
        };
        CANCELS.put(player.getEntityId(), runnable);
        new BukkitRunnable(){
            final double range;
            final double damage;
            final double rateDiv = 0.15707963267948966;
            final double distance;
            final ParticleDisplay display;
            final ParticleDisplay sweep;
            {
                this.range = SwordsmanAnnihilation.this.getExtraScaling(skilledPlayer, "range", new Object[0]);
                this.damage = SwordsmanAnnihilation.this.getExtraScaling(skilledPlayer, "damage", new Object[0]);
                this.rateDiv = 0.15707963267948966;
                this.distance = SwordsmanAnnihilation.this.getExtraScaling(skilledPlayer, "distance", new Object[0]);
                this.display = ParticleDisplay.simple(null, XMaterial.supports(16) ? Particle.SOUL_FIRE_FLAME : Particle.SPELL_WITCH);
                this.sweep = ParticleDisplay.simple(null, Particle.SWEEP_ATTACK).offset(0.3, 0.3, 0.3).withCount(5);
            }

            public void run() {
                if (atomicBoolean.get()) {
                    this.cancel();
                    return;
                }
                if (hashMap.size() >= SWORDS.length) {
                    return;
                }
                for (Entity entity : player.getNearbyEntities(this.range, this.range, this.range)) {
                    Player player2;
                    if (hashSet.contains(entity.getEntityId()) || EntityUtil.isInvalidEntity(entity) || entity instanceof Player && !ServiceHandler.canFight((Entity)player, (Entity)(player2 = (Player)entity))) continue;
                    player2 = (LivingEntity)entity;
                    new BukkitRunnable((LivingEntity)player2, entity){
                        final ThreadLocalRandom random = ThreadLocalRandom.current();
                        double t = 1.5707963267948966;
                        int dmg = 0;
                        final /* synthetic */ LivingEntity val$livingEntity;
                        final /* synthetic */ Entity val$entity;
                        {
                            this.val$livingEntity = livingEntity;
                            this.val$entity = entity;
                        }

                        public void run() {
                            if (!this.val$livingEntity.isValid() || atomicBoolean.get() || SwordsmanAnnihilation.distance(player.getLocation(), this.val$livingEntity.getLocation()) > distance) {
                                hashMap.remove(this.getTaskId());
                                hashSet.remove(this.val$entity.getEntityId());
                                this.cancel();
                                return;
                            }
                            double d = Math.cos(this.t);
                            double d2 = 2.0 * Math.cos(5.0 * this.t);
                            double d3 = d2 * Math.sin(this.t);
                            double d4 = d2 * d;
                            Vector vector = new Vector(d3, d4, 0.0);
                            Vector vector2 = this.val$livingEntity.getEyeLocation().toVector();
                            int n = hashMap.getOrDefault(this.getTaskId(), 0);
                            for (Entity entity : keySetView) {
                                int n2 = entity.getEntityId();
                                if (n != n2) {
                                    if (n != 0 || hashMap.containsValue(n2)) continue;
                                    hashMap.put(this.getTaskId(), n2);
                                    hashSet.add(this.val$entity.getEntityId());
                                }
                                Vector vector3 = new Vector(vector2.getX(), vector2.getY(), vector2.getZ());
                                XParticle.rotateAroundX(vector, this.random.nextDouble(-Math.PI, Math.PI));
                                entity.setVelocity(vector3.add(vector).subtract(entity.getLocation().toVector()));
                                display.spawn(entity.getLocation());
                                break;
                            }
                            if (++this.dmg == 5) {
                                Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> this.val$livingEntity.damage(damage, (Entity)player));
                                XSound.ENTITY_PLAYER_ATTACK_SWEEP.play((Entity)player, 5.0f, 0.5f);
                                sweep.spawn(this.val$livingEntity.getEyeLocation());
                                this.dmg = 0;
                            }
                            this.t += 0.15707963267948966;
                        }
                    }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 20L, 20L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTp(PlayerTeleportEvent playerTeleportEvent) {
        SwordsmanAnnihilation.cancelAnnihilation(playerTeleportEvent.getPlayer());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        SwordsmanAnnihilation.cancelAnnihilation(playerQuitEvent.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        SwordsmanAnnihilation.cancelAnnihilation(playerDeathEvent.getEntity());
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%damage%", this.translate(skilledPlayer, "damage"), "%duration%", this.translate(skilledPlayer, "duration"), "%range%", this.translate(skilledPlayer, "range"), "%distance%", this.translate(skilledPlayer, "distance"), "%throw_damage%", this.translate(skilledPlayer, "throw.damage"), "%throw_cooldown%", this.translate(skilledPlayer, "throw.damage")};
    }

    static {
        CANCELS = new HashMap<Integer, Runnable>();
        SWORDS = XMaterial.supports(16) ? new XMaterial[]{XMaterial.WOODEN_SWORD, XMaterial.STONE_SWORD, XMaterial.IRON_SWORD, XMaterial.GOLDEN_SWORD, XMaterial.DIAMOND_SWORD, XMaterial.NETHERITE_SWORD} : new XMaterial[]{XMaterial.WOODEN_SWORD, XMaterial.STONE_SWORD, XMaterial.IRON_SWORD, XMaterial.GOLDEN_SWORD, XMaterial.DIAMOND_SWORD};
    }
}

