/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class PriestPurification
extends Ability {
    private static final Map<UUID, Set<UUID>> BATERAYED = new HashMap<UUID, Set<UUID>>();
    private static final ImmutableList<XMaterial> FLOWERS = ImmutableList.of((Object)((Object)XMaterial.BLUE_ORCHID), (Object)((Object)XMaterial.DANDELION), (Object)((Object)XMaterial.ALLIUM), (Object)((Object)XMaterial.AZURE_BLUET), (Object)((Object)XMaterial.LILY_OF_THE_VALLEY), (Object)((Object)XMaterial.CORNFLOWER), (Object)((Object)XMaterial.LILAC), (Object)((Object)XMaterial.OXEYE_DAISY));
    private static final EnumSet<XMaterial> CROPS = EnumSet.of(XMaterial.WHEAT, new XMaterial[]{XMaterial.POTATOES, XMaterial.CARROTS, XMaterial.CARROT, XMaterial.POTATO, XMaterial.NETHER_WART, XMaterial.WHEAT_SEEDS, XMaterial.PUMPKIN_STEM, XMaterial.MELON_STEM, XMaterial.BEETROOTS, XMaterial.SUGAR_CANE, XMaterial.BAMBOO_SAPLING, XMaterial.CHORUS_PLANT, XMaterial.KELP, XMaterial.SEA_PICKLE});

    public PriestPurification() {
        super("Priest", "purification");
    }

    protected static void spreadFlower(Player player, int n, int n2) {
        int n3;
        if (n <= 0) {
            return;
        }
        Block block = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
        ArrayList<Block> arrayList = new ArrayList<Block>();
        arrayList.add(block);
        int n4 = block.getX();
        int n5 = block.getZ();
        for (n3 = n4 - n2; n3 < n4 + n2; ++n3) {
            for (int i = n5 - n2; i < n5 + n2; ++i) {
                arrayList.add(new Location(block.getWorld(), (double)n3, (double)block.getY(), (double)i).getBlock());
            }
        }
        n3 = FLOWERS.size() - 1;
        Material material = XMaterial.GRASS_BLOCK.parseMaterial();
        Material material2 = XMaterial.TALL_GRASS.parseMaterial();
        for (Block block2 : arrayList) {
            Block block3;
            if (block2.getType() == Material.DIRT) {
                block2.setType(material);
            } else if (block2.getType() != material) continue;
            if (!(block3 = block2.getRelative(BlockFace.UP)).getType().name().endsWith("AIR")) continue;
            if (MathUtils.hasChance(n / 2)) {
                block3.setType(material2);
                player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation(), 10, 0.5, 0.5, 0.5, 0.0);
                continue;
            }
            if (!MathUtils.hasChance(n)) continue;
            block3.setType(((XMaterial)((Object)FLOWERS.get(MathUtils.randInt(0, n3)))).parseMaterial());
            player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation(), 10, 0.5, 0.5, 0.5, 0.0);
        }
    }

    @Override
    public void start() {
        if (!XMaterial.isNewVersion()) {
            return;
        }
        final ParticleDisplay particleDisplay = new ParticleDisplay(Particle.VILLAGER_HAPPY, null, 30, 1.0, 1.0, 1.0);
        PriestPurification.addTask(new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    int n;
                    SkilledPlayer skilledPlayer = PriestPurification.this.checkup(player);
                    if (skilledPlayer == null || (n = skilledPlayer.getImprovementLevel(PriestPurification.this)) < 3) continue;
                    int n2 = (int)PriestPurification.this.getScaling(skilledPlayer, new Object[0]);
                    for (int i = -n2; i < n2; ++i) {
                        for (int j = -n2; j < n2; ++j) {
                            Ageable ageable;
                            BlockData blockData;
                            Block block = player.getLocation().getBlock().getRelative(i, 0, j);
                            XMaterial xMaterial = XMaterial.matchXMaterial(block.getType());
                            if (!CROPS.contains((Object)xMaterial) || !((blockData = block.getBlockData()) instanceof Ageable) || (ageable = (Ageable)blockData).getAge() == ageable.getMaximumAge()) continue;
                            ageable.setAge(ageable.getAge() + 1);
                            Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> block.setBlockData((BlockData)ageable));
                            particleDisplay.spawn(block.getLocation());
                        }
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 60L, (long)this.getExtra("Priest", "rate").getInt()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onMobPeaceBateryal(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        Set<UUID> set = BATERAYED.get(player.getUniqueId());
        if (set != null) {
            set.add(entityDamageByEntityEvent.getEntity().getUniqueId());
        } else {
            BATERAYED.put(player.getUniqueId(), new HashSet<UUID>(Collections.singleton(entityDamageByEntityEvent.getEntity().getUniqueId())));
        }
    }

    @EventHandler
    public void onBateryalKill(EntityDeathEvent entityDeathEvent) {
        Player player = entityDeathEvent.getEntity().getKiller();
        if (player == null) {
            return;
        }
        Set<UUID> set = BATERAYED.get(player.getUniqueId());
        if (set == null) {
            return;
        }
        if (set.remove(entityDeathEvent.getEntity().getUniqueId()) && set.isEmpty()) {
            BATERAYED.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onMobPeace(EntityTargetEvent entityTargetEvent) {
        String string;
        if (!(entityTargetEvent.getTarget() instanceof Player)) {
            return;
        }
        Player player = (Player)entityTargetEvent.getTarget();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = skilledPlayer.getImprovementLevel(this);
        if (n < 1) {
            return;
        }
        Entity entity = entityTargetEvent.getEntity();
        Set<UUID> set = BATERAYED.get(player.getUniqueId());
        if (set != null && set.contains(entity.getUniqueId())) {
            return;
        }
        switch (entity.getType()) {
            case GUARDIAN: 
            case SPIDER: 
            case SLIME: {
                entityTargetEvent.setCancelled(true);
                return;
            }
        }
        if (n > 2 && ((string = entity.getType().name()).equals("ENDERMAN") || string.equals("ELDER_GUARDIAN") || string.equals("PHANTOM"))) {
            entityTargetEvent.setCancelled(true);
        }
    }
}

