/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.api.events.SkillToggleAbilityEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.LocationUtils;
import org.skills.utils.xseries.XSound;

public class PriestPassive
extends Ability {
    private static final Set<UUID> jesus = new HashSet<UUID>();

    public PriestPassive() {
        super("Priest", "passive");
    }

    @Override
    public void start() {
        PriestPassive.addTask(new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SkilledPlayer skilledPlayer;
                    World.Environment environment = player.getWorld().getEnvironment();
                    if (environment == World.Environment.NORMAL || !(skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player)).hasAbility(PriestPassive.this)) continue;
                    if (environment == World.Environment.NETHER) {
                        Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> PriestPassive.this.applyEffects(skilledPlayer, "effects.nether", (LivingEntity)player));
                        XSound.ENTITY_WITHER_AMBIENT.play((Entity)player);
                        continue;
                    }
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> PriestPassive.this.applyEffects(skilledPlayer, "effects.end", (LivingEntity)player));
                    XSound.ENTITY_ENDER_DRAGON_AMBIENT.play((Entity)player);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 100L, (long)this.getExtra("Priest", "interval").getInt() * 20L));
    }

    @EventHandler(ignoreCancelled=true)
    public void jesus(PlayerMoveEvent playerMoveEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
            if (!LocationUtils.hasMoved(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
                return;
            }
            Player player = playerMoveEvent.getPlayer();
            if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
                return;
            }
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (!this.getExtra(skilledPlayer, "jesus").getBoolean()) {
                return;
            }
            Block block = player.getLocation().getBlock();
            String string = block.getType().name();
            String string2 = block.getRelative(BlockFace.DOWN).getType().name();
            if (string.endsWith("WATER") || string2.endsWith("WATER")) {
                if (player.getAllowFlight()) {
                    player.spawnParticle(Particle.CLOUD, player.getLocation(), 5, 0.1, 0.1, 0.1, 0.1);
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                    player.setAllowFlight(true);
                    player.setFlying(true);
                    jesus.add(player.getUniqueId());
                });
                player.spawnParticle(Particle.CLOUD, player.getLocation(), 30, 0.3, 0.0, 0.3, 0.3);
            } else {
                if (!player.getAllowFlight()) {
                    return;
                }
                if (!jesus.remove(player.getUniqueId())) {
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                });
            }
        });
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (jesus.remove(player.getUniqueId())) {
            player.setAllowFlight(false);
            player.setFlying(false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (jesus.remove(player.getUniqueId())) {
            player.setAllowFlight(false);
            player.setFlying(false);
        }
    }

    @EventHandler
    public void onPassiveDisable(SkillToggleAbilityEvent skillToggleAbilityEvent) {
        if (!skillToggleAbilityEvent.isDisabled()) {
            return;
        }
        if (!skillToggleAbilityEvent.getAbility().getName().endsWith("passive")) {
            return;
        }
        if (!skillToggleAbilityEvent.getInfo().getSkillName().equalsIgnoreCase("priest")) {
            return;
        }
        Player player = skillToggleAbilityEvent.getPlayer();
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!jesus.remove(player.getUniqueId())) {
            return;
        }
        player.setAllowFlight(false);
        player.setFlying(false);
    }

    @EventHandler
    public void lavaEscape(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.LAVA) {
            return;
        }
        final Player player = (Player)entityDamageEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        entityDamageEvent.setCancelled(true);
        player.setFireTicks(0);
        Vector vector = new Vector(-player.getEyeLocation().getDirection().getX(), 1.5, -player.getEyeLocation().getDirection().getZ());
        player.setVelocity(vector);
        XSound.ENTITY_GENERIC_EXTINGUISH_FIRE.play((Entity)player);
        new BukkitRunnable(){
            int i = 5;

            public void run() {
                player.spawnParticle(Particle.FLAME, player.getLocation(), 10, 0.01, 0.01, 0.01, 0.1);
                --this.i;
                if (this.i == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
    }
}

