/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class PriestNaturesForce
extends ActiveAbility {
    private static final String NATURES_FORCE = "NATURES_FORCE";
    private static final String BEEHIVE = "BEEHIVE";
    private static final String NATURES_FORCE_TARGET = "NATURES_FORCE_TARGET";
    private static final ParticleDisplay DEATH = ParticleDisplay.simple(null, Particle.FLAME).withCount(100).offset(0.5, 0.5, 0.5);

    public PriestNaturesForce() {
        super("Priest", "natures_force", false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        final SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        final Location location = player.getEyeLocation();
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        final Block block = livingEntity.getLocation().add(0.0, 2.0, 0.0).getBlock();
        final Material material = block.getType();
        block.setType(Material.BEEHIVE);
        XParticle.spikeSphere(1.0, 20.0, 5, 1.0, 2.0, ParticleDisplay.simple(block.getLocation(), Particle.SPELL_WITCH));
        final ParticleDisplay particleDisplay = ParticleDisplay.simple(block.getLocation(), Particle.SMOKE_LARGE);
        particleDisplay.count = 100;
        particleDisplay.offset(0.5, 0.5, 0.5);
        XSound.ENTITY_BEE_LOOP.play(location, 3.0f, 0.0f);
        final long l = (long)this.getExtraScaling(skilledPlayer, "interval", new Object[0]);
        int n = new BukkitRunnable(){
            final ThreadLocalRandom random = ThreadLocalRandom.current();
            final double damage = PriestNaturesForce.this.getScaling(skilledPlayer, new Object[0]);
            final Location hiveLoc = block.getLocation();
            long duration = (long)PriestNaturesForce.this.getExtraScaling(skilledPlayer, "duration", new Object[0]);
            int repeat = 0;
            double rotation = 0.0;

            public void run() {
                Location location2 = this.hiveLoc.clone().add(this.random.nextDouble(-1.0, 1.0), this.random.nextDouble(-1.0, 1.0), this.random.nextDouble(-1.0, 1.0));
                Bee bee = (Bee)location2.getWorld().spawnEntity(location2, EntityType.BEE);
                bee.setCannotEnterHiveTicks(Integer.MAX_VALUE);
                bee.setHive(null);
                bee.setFlower(null);
                bee.setHasNectar(false);
                bee.setHasStung(false);
                bee.setAnger(Integer.MAX_VALUE);
                bee.addPotionEffect(XPotion.SPEED.parsePotion(1000000, 6));
                bee.setMetadata(PriestNaturesForce.NATURES_FORCE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)this.damage));
                bee.setMetadata(PriestNaturesForce.NATURES_FORCE_TARGET, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)livingEntity));
                bee.setTarget(livingEntity);
                XSound.ENTITY_BEE_LOOP_AGGRESSIVE.play(location, 3.0f, 0.0f);
                particleDisplay.spawn(location2);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SkillsPro.get(), () -> {
                    if (bee.isValid()) {
                        DEATH.spawn(bee.getLocation());
                        bee.setHealth(0.0);
                    }
                }, this.duration * 20L);
                this.rotation += 0.1;
                if (this.rotation > 360.0) {
                    this.rotation = 0.0;
                }
                this.repeat = (int)((long)this.repeat + l);
                if (this.repeat >= 20) {
                    this.repeat = 0;
                    XSound.BLOCK_BEEHIVE_WORK.play(location, 0.1f, 2.0f);
                }
                this.duration -= l;
                if (this.duration <= 0L) {
                    this.cancel();
                    block.setType(material);
                    block.removeMetadata(PriestNaturesForce.BEEHIVE, (Plugin)SkillsPro.get());
                    particleDisplay.spawn();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, l * 20L).getTaskId();
        block.setMetadata(BEEHIVE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)n));
    }

    @EventHandler
    public void onDeath(EntityDeathEvent entityDeathEvent) {
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity.hasMetadata(NATURES_FORCE)) {
            DEATH.spawn(livingEntity.getLocation());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBeehiveBreak(BlockBreakEvent blockBreakEvent) {
        Block block = blockBreakEvent.getBlock();
        List list = block.getMetadata(BEEHIVE);
        if (list.isEmpty()) {
            return;
        }
        int n = ((MetadataValue)list.get(0)).asInt();
        Bukkit.getScheduler().cancelTask(n);
        blockBreakEvent.setCancelled(true);
    }

    @EventHandler
    public void onTargetChange(EntityTargetEvent entityTargetEvent) {
        if (!(entityTargetEvent.getEntity() instanceof Bee)) {
            return;
        }
        Bee bee = (Bee)entityTargetEvent.getEntity();
        List list = bee.getMetadata(NATURES_FORCE_TARGET);
        if (list.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)((MetadataValue)list.get(0)).value();
        entityTargetEvent.setTarget((Entity)livingEntity);
    }

    @EventHandler(ignoreCancelled=true)
    public void tntDmaage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Bee)) {
            return;
        }
        Bee bee = (Bee)entityDamageByEntityEvent.getDamager();
        List list = bee.getMetadata(NATURES_FORCE);
        if (list.isEmpty()) {
            return;
        }
        double d = ((MetadataValue)list.get(0)).asDouble();
        entityDamageByEntityEvent.setDamage(d);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> bee.setHasStung(false), 1L);
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%duration%", this.translate(skilledPlayer, "duration"), "%interval%", this.translate(skilledPlayer, "interval")};
    }
}

