/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.ArrayList;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.utils.MathUtils;

public class PriestMindPossession
extends Ability {
    public PriestMindPossession() {
        super("Priest", "mind_possession");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamageParalyze(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = skilledPlayer.getImprovementLevel(this);
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, new Object[0]))) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        ArrayList<PotionEffect> arrayList = new ArrayList<PotionEffect>();
        arrayList.add(new PotionEffect(PotionEffectType.BLINDNESS, n * 5 * 20, 0));
        if (n > 1) {
            arrayList.add(new PotionEffect(PotionEffectType.SLOW, n * 10 * 20, 0));
            player.spawnParticle(Particle.SPELL_MOB_AMBIENT, livingEntity.getEyeLocation(), 30, 0.3, 0.0, 0.3, 0.3);
        }
        livingEntity.addPotionEffects(arrayList);
    }
}

