/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class PriestKindlingOfLife
extends ActiveAbility {
    private static final String SPELL = "PRIEST_SPELL";

    public PriestKindlingOfLife() {
        super("Priest", "kindling_of_life", true);
    }

    @Override
    public void useSkill(final Player player) {
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = skilledPlayer.getImprovementLevel(this);
        if (player.isSneaking()) {
            XSound.ENTITY_GENERIC_DRINK.play(player.getLocation());
            ParticleDisplay.simple(player.getLocation(), Particle.HEART).withCount(n * 20).offset(0.5, 0.5, 0.5).spawn();
            double d = player.getHealth() + this.getScaling(skilledPlayer, new Object[0]);
            double d2 = VersionSupport.getMaxHealth((LivingEntity)player);
            if (d > d2) {
                d = d2;
            }
            player.setHealth(d);
            return;
        }
        Vector vector = player.getEyeLocation().getDirection().multiply(n * 2);
        final Projectile projectile = player.launchProjectile(ThrownPotion.class, vector);
        projectile.setMetadata(SPELL, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)n));
        XSound.ENTITY_SPLASH_POTION_THROW.play((Entity)player);
        new BukkitRunnable(){
            int i = 5;

            public void run() {
                player.spawnParticle(Particle.HEART, projectile.getLocation(), 10, 0.01, 0.01, 0.01, 0.1);
                --this.i;
                if (this.i == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
        XSound.ITEM_FIRECHARGE_USE.play((Entity)player);
    }

    @EventHandler
    public void spellHit(ProjectileHitEvent projectileHitEvent) {
        Entity entity = projectileHitEvent.getHitEntity();
        if (entity == null || !entity.isValid() || !(entity instanceof LivingEntity)) {
            return;
        }
        ProjectileSource projectileSource = projectileHitEvent.getEntity().getShooter();
        if (projectileSource == null) {
            return;
        }
        if (!projectileHitEvent.getEntity().hasMetadata(SPELL)) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)projectileSource));
        LivingEntity livingEntity = (LivingEntity)entity;
        XSound.ENTITY_EXPERIENCE_ORB_PICKUP.play((Entity)projectileHitEvent.getEntity().getShooter(), 2.0f, 0.0f);
        entity.getLocation().getWorld().spawnParticle(Particle.HEART, entity.getLocation(), 30, 0.5, 0.5, 0.5, 0.5);
        double d = livingEntity.getHealth() + this.getScaling(skilledPlayer, new Object[0]);
        double d2 = VersionSupport.getMaxHealth(livingEntity);
        if (d > d2) {
            d = d2;
        }
        livingEntity.setHealth(d);
    }
}

