/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.EnumSet;
import java.util.List;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.skills.abilities.ActiveAbility;
import org.skills.abilities.priest.PriestPurification;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class PriestAsclepius
extends ActiveAbility {
    public static final EnumSet<XPotion> DEBUFFS = EnumSet.of(XPotion.BAD_OMEN, new XPotion[]{XPotion.BLINDNESS, XPotion.CONFUSION, XPotion.HARM, XPotion.HUNGER, XPotion.LEVITATION, XPotion.POISON, XPotion.SATURATION, XPotion.SLOW, XPotion.SLOW_DIGGING, XPotion.SLOW_FALLING, XPotion.UNLUCK, XPotion.WEAKNESS, XPotion.WITHER});

    public PriestAsclepius() {
        super("Priest", "asclepius", true);
    }

    @Override
    public void useSkill(Player player) {
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = skilledPlayer.getImprovementLevel(this);
        PriestPurification.spreadFlower(player, (int)this.getExtraScaling(skilledPlayer, "spread-flower-chance", new Object[0]), 3);
        double d = this.getExtraScaling(skilledPlayer, "damage", new Object[0]);
        double d2 = this.getExtraScaling(skilledPlayer, "range", new Object[0]);
        List list = player.getNearbyEntities(d2, d2, d2);
        list.add(player);
        for (Entity entity : list) {
            if (!(entity instanceof Player)) continue;
            Player player2 = (Player)entity;
            if (ServiceHandler.areFriendly((Entity)player, entity)) {
                this.applyEffects(skilledPlayer, (LivingEntity)player2);
                XSound.ENTITY_GENERIC_DRINK.play(entity);
                player2.getLocation().getWorld().spawnParticle(Particle.SPELL_WITCH, player2.getLocation(), 30, 0.5, 0.5, 0.5, 0.1);
                if (n <= 2) continue;
                for (PotionEffect potionEffect : player2.getActivePotionEffects()) {
                    if (!DEBUFFS.contains((Object)XPotion.matchXPotion(potionEffect.getType()))) continue;
                    player2.removePotionEffect(potionEffect.getType());
                }
                continue;
            }
            if (!(d > 0.0)) continue;
            player2.getLocation().getWorld().spawnParticle(Particle.LAVA, player2.getLocation(), 30, 0.5, 0.5, 0.5, 0.1);
            player2.damage(d);
        }
        XSound.ITEM_TOTEM_USE.play((Entity)player);
        XSound.ENTITY_BAT_TAKEOFF.play((Entity)player);
        XParticle.circle(d2 * 2.0, d2 * 8.0, ParticleDisplay.simple(player.getLocation(), Particle.SMOKE_LARGE));
        if (n > 1) {
            XParticle.helix(SkillsPro.get(), n + 1, 1.5, 0.05, 1.0, 6, 3, true, false, new ParticleDisplay(Particle.ENCHANTMENT_TABLE, player.getLocation(), 1));
        }
    }
}

