/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.types.SkillScaling;
import org.skills.utils.xseries.XMaterial;

public class MagePassive
extends Ability {
    public MagePassive() {
        super("Mage", "passive");
    }

    @EventHandler(ignoreCancelled=true)
    public void onMageAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getDamager();
            if (player.getItemInHand() == null) {
                return;
            }
            if (!player.getItemInHand().getType().toString().contains("HOE")) {
                return;
            }
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            ConfigurationSection configurationSection = this.getExtra(skilledPlayer, "hoe-damage").getSection();
            XMaterial xMaterial = XMaterial.matchXMaterial(player.getItemInHand());
            double d = this.getAbsoluteScaling(skilledPlayer, configurationSection.getString(xMaterial.name()), "damage", entityDamageByEntityEvent.getDamage());
            int n = (int)this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent.getDamage());
            skilledPlayer.setEnergy(Math.min(skilledPlayer.getEnergy() + (double)n, skilledPlayer.getScaling(SkillScaling.MAX_ENERGY)));
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d);
        }
    }
}

