/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.spigotmc.event.entity.EntityDismountEvent;

public class MageNeptune
extends Ability {
    private static final String NEPTUNE = "NEPTUNE";

    public MageNeptune() {
        super("Mage", "neptune");
    }

    @EventHandler(ignoreCancelled=true)
    public void onTridentLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        if (!XMaterial.isNewVersion()) {
            return;
        }
        Projectile projectile = projectileLaunchEvent.getEntity();
        if (!(projectile instanceof Trident)) {
            return;
        }
        Trident trident = (Trident)projectile;
        ProjectileSource projectileSource = trident.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getImprovementLevel(this) < 3) {
            return;
        }
        if (player.getInventory().getItemInOffHand().getType() == Material.TRIDENT && player.isSneaking()) {
            trident.addPassenger((Entity)player);
            trident.setMetadata(NEPTUNE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDismount(EntityDismountEvent entityDismountEvent) {
        if (entityDismountEvent.getDismounted().hasMetadata(NEPTUNE)) {
            entityDismountEvent.setCancelled(true);
            entityDismountEvent.getDismounted().removeMetadata(NEPTUNE, (Plugin)SkillsPro.get());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTrident(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!XMaterial.isNewVersion()) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Trident)) {
            return;
        }
        ProjectileSource projectileSource = ((Trident)entityDamageByEntityEvent.getDamager()).getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)projectileSource;
        final SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, entityDamageByEntityEvent));
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chances.lightning", entityDamageByEntityEvent))) {
            player.getWorld().strikeLightning(livingEntity.getLocation());
        }
        if (MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chances.multiply", entityDamageByEntityEvent))) {
            new BukkitRunnable(){
                int repeat;
                {
                    this.repeat = (int)MageNeptune.this.getExtraScaling(skilledPlayer, "multiply", new Object[0]);
                }

                public void run() {
                    if (!livingEntity.isValid()) {
                        this.cancel();
                    }
                    Location location = livingEntity.getLocation().clone().add(0.0, 10.0, 0.0);
                    int n = MathUtils.randInt(0, 10);
                    int n2 = MathUtils.randInt(0, 10);
                    Location location2 = location.clone().add((double)n, 0.0, (double)n2);
                    Location location3 = livingEntity.getEyeLocation();
                    Vector vector = location3.toVector().subtract(location2.toVector());
                    location.getWorld().spawnParticle(Particle.CLOUD, location2, 100, 0.5, 0.5, 0.5, 0.0);
                    Trident trident = (Trident)location.getWorld().spawnEntity(location2, EntityType.TRIDENT);
                    trident.setVelocity(vector.multiply(0.5));
                    if (this.repeat-- <= 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 10L, 10L);
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%chances_lightning%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer).getString("chances.lightning")), "%chances_multiply%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer).getString("chances.multiply")), "%multiply%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer).getString("multiply"))};
    }
}

