/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.versionsupport.VersionSupport;

public class MageHealSpell
extends Ability {
    public MageHealSpell() {
        super("Mage", "heal_spell");
    }

    @EventHandler
    public void onMageAttack(EntityRegainHealthEvent entityRegainHealthEvent) {
        if (entityRegainHealthEvent.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED && entityRegainHealthEvent.getRegainReason() != EntityRegainHealthEvent.RegainReason.REGEN) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityRegainHealthEvent.getEntity().getLocation())) {
            return;
        }
        if (entityRegainHealthEvent.getEntity() instanceof Player) {
            if (ServiceHandler.isNPC(entityRegainHealthEvent.getEntity())) {
                return;
            }
            Player player = (Player)entityRegainHealthEvent.getEntity();
            if (player.getItemInHand() == null) {
                return;
            }
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            int n = VersionSupport.getHealthPercent((LivingEntity)player);
            if ((double)n > this.getExtraScaling(skilledPlayer, "health", new Object[0])) {
                return;
            }
            entityRegainHealthEvent.setAmount(entityRegainHealthEvent.getAmount() + this.getScaling(skilledPlayer, "regain", entityRegainHealthEvent.getAmount()));
        }
    }
}

